/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils;

import java.util.ArrayList;
import java.util.List;

public class ListUtils {

  private ListUtils() {
    // no instances
  }

  @SafeVarargs
  public static <T> List<T> getList(T... elements) {
    List<T> list = new ArrayList<>();
    for (T element : elements) {
      list.add(element);
    }
    return list;
  }
}
