/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils;

import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ResultUtils {

  private ResultUtils() {
    // hidden
  }

  public static Result convert(Iterable<? extends Map<String, ?>> result) {
    final Result theResult;
    if (result == null) {
      theResult = null;
    } else if (result instanceof Result result1) {
      theResult = result1;
    } else {
      List<? extends Map<String, ?>> rows =
          StreamSupport.stream(result.spliterator(), true).collect(Collectors.toList());
      theResult = ResultBuilder.selectedRows(rows).result();
    }
    return theResult;
  }
}
