/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.mt;

import com.sap.cds.CdsCommunicationException;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.CdsErrorStatuses;
import org.apache.http.HttpStatus;

public class TenantUtils {

  /**
   * Determines whether the messaging error event context describes missing/unknown tenant.
   *
   * @param th throwable error
   * @return <code>true</code> if unknown and <code>false</code> otherwise
   */
  public static boolean isUnknownTenant(Throwable th) {
    Throwable cause = th;
    while (cause != null) {
      // tenant aware data source check
      if (cause instanceof ServiceException se
          && se.getErrorStatus() == CdsErrorStatuses.TENANT_NOT_EXISTS) {
        return true;
      }
      // MTXS check
      if (cause instanceof CdsCommunicationException cce
          && cce.getHttpStatusCode() == HttpStatus.SC_NOT_FOUND) {
        return true;
      }
      cause = cause.getCause();
    }
    return false;
  }
}
