/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.tools.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class Cloner {
  private static final ObjectMapper mapper = new ObjectMapper();

  private Cloner() {}

  public static <T> T clone(T source, Class<T> valueType) throws InternalError {
    if (source == null) return null;
    try {
      return mapper.readValue(mapper.writeValueAsString(source), valueType);
    } catch (IOException e) {
      throw new InternalError("Could not convert between object and json", e);
    }
  }
}
