/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.tools.api;

import java.util.Map;

public class InstanceCreationOptions {

  private Map<String, Object> provisioningParameters = null;
  private Map<String, Object> bindingParameters = null;

  public Map<String, Object> getProvisioningParameters() {
    return provisioningParameters;
  }

  public InstanceCreationOptions withProvisioningParameters(
      Map<String, Object> provisioningParameters) {
    this.provisioningParameters = provisioningParameters;
    return this;
  }

  public Map<String, Object> getBindingParameters() {
    return bindingParameters;
  }

  public InstanceCreationOptions withBindingParameters(Map<String, Object> bindingParameters) {
    this.bindingParameters = bindingParameters;
    return this;
  }
}
