/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.tools.api;

import java.util.Optional;
import org.apache.http.Header;

/**
 * Data class that combines returned payload, code and eTag
 *
 * @param <R>: type of returned payload
 */
public final class ServiceResponse<R> {
  private Optional<R> payload = Optional.empty();
  private int httpStatusCode;
  private Optional<String> eTag = Optional.empty();
  private Header[] headers;

  public Optional<R> getPayload() {
    return payload;
  }

  public void setPayload(Optional<R> payload) {
    this.payload = payload;
  }

  public int getHttpStatusCode() {
    return httpStatusCode;
  }

  public void setHttpStatusCode(int httpStatusCode) {
    this.httpStatusCode = httpStatusCode;
  }

  public Optional<String> getETag() {
    return eTag;
  }

  public void setETag(Optional<String> eTag) {
    this.eTag = eTag;
  }

  public Header[] getHeaders() {
    return headers;
  }

  public void setHeaders(Header[] headers) {
    this.headers = headers;
  }
}
