/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.tools.impl;

import com.sap.cds.services.utils.lib.tools.api.ServiceResponse;

public class NoRetryException extends Exception {
  private final transient ServiceResponse<?> response;

  public NoRetryException(ServiceResponse<?> response) {
    this.response = response;
  }

  public NoRetryException(String message, ServiceResponse<?> response) {
    super(message);
    this.response = response;
  }

  public NoRetryException(String message, Throwable cause, ServiceResponse<?> response) {
    super(message, cause);
    this.response = response;
  }

  public NoRetryException(Throwable cause, ServiceResponse<?> response) {
    super(cause);
    this.response = response;
  }

  public ServiceResponse<?> getResponse() {
    return response;
  }
}
