/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.tools.impl;

import com.sap.cds.services.utils.lib.tools.api.ServiceResponse;
import java.time.Duration;

public class RetryException extends Exception implements WaitTimeSupplier {
  private final transient ServiceResponse<?> response;
  private final transient Duration requestedWaitTime;

  public RetryException(ServiceResponse<?> response, Duration requestedWaitTime) {
    this.response = response;
    this.requestedWaitTime = requestedWaitTime;
  }

  public RetryException(Throwable cause, ServiceResponse<?> response, Duration requestedWaitTime) {
    super(cause);
    this.response = response;
    this.requestedWaitTime = requestedWaitTime;
  }

  public ServiceResponse<?> getResponse() {
    return response;
  }

  @Override
  public Duration getWaitTime() {
    return requestedWaitTime;
  }
}
