/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;

public enum CdsErrorStatuses implements ErrorStatus
{
    INVALID_CQN(400001, "Invalid CQN: {}", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_DATE_VALUE(400002, "Provided value in query parameter '{}' is not a valid date value (expected ISO 8601 date time format)", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_DRAFT_ENABLED(400003, "Entity '{}' is not draft enabled", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_ROOT(400004, "Entity '{}' is not the root entity of the draft-enabled composition tree", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_ACTIVE(400005, "Only active draft-enabled entities (IsActiveEntity = true) are allowed", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    ENTITY_NOT_INACTIVE(400006, "Only inactive draft-enabled entities (IsActiveEntity = false) are allowed", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_URI_RESOURCE(400007, "URI resource is invalid", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_PAYLOAD(400008, "Could not deserialize request payload: {}", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_EXPAND_STAR(400009, "Expand '*' can't be combined with further expands", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_SUBSTRING(400010, "Invalid number of parameters for filter function 'substring'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    MISSING_CONTENT_TYPE(400011, "'Content-Type' request header required", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    VALUE_OUT_OF_RANGE(400012, "Value of element '{}' is out of range of {}", "Enter a value that is within the range of {1}.", "Enter a value that is within the range of [0, 100].", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    DRAFT_DEEP_UPDATE(400013, "Deep updates are not allowed when patching an inactive draft-enabled entity (IsActiveEntity = false)", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_ENUM(400015, "Provided enum value of element '{}' is not in the list of allowed enum values '{}'", "Enter a value that is within the list of allowed values.", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_SORT_ELEMENT(400016, "Could not sort by element '{}' of entity '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_PARAMETERIZED_VIEW(400017, "You need to use the 'Set' navigation property when accessing a parameterized view", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_STRING_VALUE(400018, "Provided value of element '{}' does not match the expected pattern", "Enter a value that is within the expected pattern.", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    EXCEEDED_FIELD_LENGTH(400019, "Provided value of element '{}' exceeds maximum length of {}", "Enter a value that is within the maximum allowed length of {1,number,integer} characters.", "Enter a value that is within the maximum allowed length of 10 characters.", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    NO_CUSTOM_AGGREGATE_DEFINED(400020, "No custom aggregate is defined for element '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    MISSING_ISACTIVEENTITY_KEY(400021, "The IsActiveEntity key is missing for path segments prior to an association to a draft enabled entity", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    UNKONWN_AGGREGATION_METHOD(400022, "The aggregate method '{}' is unknown", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    TARGET_ENTITY_MISSING(400023, "Foreign key value doesn't exist", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_CHARSET(400024, "Content-Type contains invalid charset", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    UNSUPPORTED_CONTENT_TYPE(400025, "Unsupported content type '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    UNSUPPORTED_PARAMETER_VALUE(400026, "Unsupported value '{}' of parameter '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    MALFORMED_SKIPTOKEN(400027, "Value of $skiptoken is malformed", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    BATCH_TOO_MANY_REQUESTS(400028, "Batch request contains too many requests", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INLINE_COUNT_ON_TO_ONE_ASSOC(400029, "Inline count is not permitted on to-one association '{}'", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    UNSUPPORTED_STAR(400030, "'*' is not supported", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    FORBIDDEN_VALUE(400031, "Payload for '{}' contains forbidden values", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    CONSTRAINT_VIOLATED(400032, "Constraint '{}' violated", "Enter a valid value.", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    VALUE_NOT_APPLICABLE(400033, "Value of element '{}' in entity '{}' must not be set", "Value must not be set.", "Value must not be set. Error text displayed on a field, in case a inapplicable value is set.", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    TENANT_CONTEXT_MISSING(401001, "Ensure authenticated user context is provided and contains tenant information", (ErrorStatus)ErrorStatuses.UNAUTHORIZED),
    EVENT_UNAUTHENTICATED(401003, "Not authenticated to send event '{}' to '{}'", "You need to be logged in.", (ErrorStatus)ErrorStatuses.UNAUTHORIZED),
    EVENT_FORBIDDEN(403001, "Not authorized to send event '{}' to '{}'", "You're not authorized to access this resource.", (ErrorStatus)ErrorStatuses.FORBIDDEN),
    EVENT_FORBIDDEN_UNSUPPORTED_USER_ATTRIBUTES(403002, "Not authorized to send event '{}' to '{}'. Authorization requires a unique value of user attribute '{}'.", "You're not authorized to access this resource.", (ErrorStatus)ErrorStatuses.FORBIDDEN),
    SERVICE_NOT_FOUND(404001, "Service '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ENTITY_NOT_FOUND(404002, "Entity '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ACTION_NOT_FOUND(404003, "Action '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    FUNCTION_NOT_FOUND(404004, "Function '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ASSOCIATION_NOT_FOUND(404005, "Association '{}' in entity '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ELEMENT_NOT_FOUND(404006, "Element '{}' of entity '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    JOB_NOT_FOUND(404008, "Asynchronous schema deployment job '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ENTITY_INSTANCE_NOT_FOUND(404009, "Entity '{}' with key(s) '{}' not found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    FUNCTION_RETURN_VALUE_NOT_FOUND(404010, "Function '{}' should return a single value, but no return value found", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    ENTITY_NOT_READABLE(405001, "Entity '{}' is not readable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    ENTITY_NOT_INSERTABLE(405002, "Entity '{}' is not insertable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    ENTITY_NOT_UPDATABLE(405003, "Entity '{}' is not updatable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    ENTITY_NOT_DELETABLE(405004, "Entity '{}' is not deletable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    ENTITY_NOT_DELTA_UPDATABLE(405005, "Entity '{}' is not delta updatable", (ErrorStatus)ErrorStatuses.METHOD_NOT_ALLOWED),
    VALUE_ACCESS_NOT_ALLOWED(406001, "Not allowed to access $value of stream element '{}'", (ErrorStatus)ErrorStatuses.NOT_ACCEPTABLE),
    PARENT_NOT_EXISTING(409002, "Couldn't find parent entity for entity '{}'", (ErrorStatus)ErrorStatuses.CONFLICT),
    VALUE_REQUIRED(409003, "Value of element '{}' in entity '{}' is required", "Provide the missing value.", "Provide the missing value. Error text displayed on a field, in case a mandatory value is not set.", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    MULTIPLE_PARENTS(409004, "Found {} parent entities for entity '{}', but only a single one is allowed", (ErrorStatus)ErrorStatuses.CONFLICT),
    MULTIPLE_SINGLETON_ENTRIES(409005, "Only a single entry is allowed, when upserting an existing singleton", (ErrorStatus)ErrorStatuses.CONFLICT),
    UNIQUE_CONSTRAINT_VIOLATED(409006, "Unique constraint violated when inserting or updating entity '{}'", (ErrorStatus)ErrorStatuses.CONFLICT),
    LOCK_TIMEOUT(409007, "Timeout while waiting for lock on entity '{}'", (ErrorStatus)ErrorStatuses.CONFLICT),
    MISSING_VALUE(409008, "Value of element '{}' is required", "Provide the missing value.", "Provide the missing value. Error text displayed on a field, in case a mandatory value is not set.", (ErrorStatus)ErrorStatuses.BAD_REQUEST),
    INVALID_FLOW_TRANSITION(409009, "Invalid entry state for transition. Action requires '{}' to be one of '{}', but was '{}'.", (ErrorStatus)ErrorStatuses.CONFLICT),
    ETAG_FAILED(412001, "ETag condition not met", (ErrorStatus)ErrorStatuses.PRECONDITION_FAILED),
    MISDIRECTED_ENTITY(421001, "Service '{}' does not contain entity '{}' and CQN statement can't be projected onto the service", (ErrorStatus)ErrorStatuses.MISDIRECTED_REQUEST),
    ETAG_REQUIRED(428001, "'If-Match' or 'If-None-Match' request header with etag condition required", (ErrorStatus)ErrorStatuses.PRECONDITION_REQUIRED),
    ETAG_VALUE_INVALID(428002, "Invalid ETag: Value could not be converted to '{}'", (ErrorStatus)ErrorStatuses.PRECONDITION_REQUIRED),
    NO_ON_HANDLER(50001001, "No ON handler completed the processing", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_FAILED(50001002, "Could not create handler instance of type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_NOT_ACCESSIBLE(50001003, "Can't access method handle for '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_SERVICE_REQUIRED(50001004, "Failed to register handler method '{}': No service name specified.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    HANDLER_EVENT_REQUIRED(50001005, "Failed to register handler method '{}': No event definition in annotations or arguments.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_EVENT_MISMATCH(50001006, "EventContext '{}' is bound to event '{}' and does not match event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_MISSING_ANNOTATION(50001007, "EventContext '{}' is missing required @EventName annotation", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_MISSING_ANNOTATION(50001008, "Method '{}' has parameter of EventContext type '{}' which misses required @EventName annotation", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_MULTIPLE_EVENTS(50001009, "Method '{}' has parameter of EventContext type '{}' but is registered for multiple events", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_MISMATCH(50001010, "Method '{}' has parameter of EventContext type '{}' which does not exactly fit registered event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_CONTEXT_ARGUMENT_DUPLICATES(50001011, "Method '{}' declares multiple EventContext arguments, but only a maximum of one is supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    POJO_ARGUMENT_MISMATCH(50001012, "Event '{}' not supported, when requiring argument '{}' in method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    POJO_ARGUMENT_DUPLICATES(50001013, "Method '{}' declares multiple entity-based arguments, but only a maximum of one is supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RETURN_TYPE_MISMATCH(50001014, "Event '{}' not supported, when returning '{}' in method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESOLVING_PARAMETER_TYPE_FAILED(50001015, "Can't resolve parameter type '{}' of method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESOLVING_RETURN_TYPE_FAILED(50001016, "Can't resolve return type '{}' of method '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_TYPE(50001017, "'{}' is not a parameterized type", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    PROCEED_OUTSIDE_ON(50001018, "EventContext.proceed() must not be called outside of the ON phase", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNEXPECTED_EVENT(50002001, "Unexpected event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNKNOWN_EVENT_PHASE(50002002, "Unknown event phase '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_NAME_REQUIRED(50002003, "Event name must not be null or empty", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SERVICE_NAME_REQUIRED(50002004, "Service name must not be null or empty", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    DUPLICATE_SERVICE(50002005, "Can't register service with duplicate service name '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CHANGESET_CANCELATION_FAILED(50003001, "Unexpected exception during cancelation of member '{}' in ChangeSet '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CHANGESET_COMPLETION_FAILED(50003002, "Unexpected exception during completion of member '{}' in ChangeSet '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MULTIPLE_CHANGE_SET_MEMBERS(50003003, "A member is already registered on ChangeSet '{}': Only a single member is supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    PLAIN_REQUEST_CONTEXT_NESTING(50003004, "Can't nest PlainRequestContextHolder", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TRANSACTION_TENANT_MISMATCH(50003005, "Database transaction was started for tenant '{}', but now found active tenant '{}': Create dedicated ChangeSet Contexts for each tenant", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TEMPORARY_REQUEST_CONTEXT_MESSAGES(50003006, "A messages object cannot be retrieved from a temporary RequestContext", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    FEATURETOGGLESINFO_OVERRIDE(50003008, "Setting FeatureTogglesInfo in a nested RequestContext is not allowed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TRANSACTION_INITIALIZATION_FAILED(50003009, "Failed to start a new transaction", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    DUPLICATE_CHANGE_SET_MEMBERS(50003010, "A member with name '{}' is already registered on ChangeSet '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_WHERE_CONDITION(50004001, "Invalid where condition '{}' for entity '{}', event '{}' and user '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE(50004002, "Failed to read CSV file from path '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_PARENT_ENTITY(50004003, "Failed to find parent entity of '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_KEYS_IN_RESULT(50004004, "Failed to determine keys of entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_ANNOTATION(50004005, "Invalid annotation '{}' for element '{}' in entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSN(50004006, "Failed to load CDS model from CSN file at resource path '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INCONSISTENT_WHERE_CONDITION(50004007, "No CXN expression found for where condition '{}' used for instance-based authorization of entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_BATCH_UPDATE(50004008, "Invalid batched update: Parameter value list size {} does not match batch size {}", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_ANNOTATION_ENTITY(50004009, "Invalid annotation '{}' in entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_FLOW_ANNOTATION(50004010, "Invalid value in flow action annotation '@{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_SERVICE_BINDING(50005001, "No service binding with tag '{}' found", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MULTIPLE_SERVICE_BINDING(50005002, "Multiple service bindings with tag '{}' found: Only a single one is allowed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_DATA_SOURCE_PROVIDER(50005003, "Could not build SQL DataSource from service binding '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    JDBC_CONNECTION_FAILED(50005004, "Can't obtain JDBC SQL connection", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_SERVICE_NAME(50005005, "Could not find service binding with name '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SUBSCRIBER_FAILED(50006001, "Could not initialize multitenant subscription client", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INSTANCE_MANAGER_CLIENT_FAILED(50006002, "Could not create Service Manager client from service binding '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SUBSCRIPTION_FAILED(50006003, "Failed to process subscription of tenant '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNSUBSCRIPTION_FAILED(50006004, "Failed to cancel subscription of tenant '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    DEPLOYMENT_FAILED(50006005, "Failed to deploy schema for tenant(s) '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    JOB_STATUS_UPDATE_FAILED(50006006, "Failed to update status for asynchronous schema deployment job '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SUBSCRIBE_CALLBACK_FAILED(50006007, "Failed to call SaaS Provisioning service after subscribe request of tenant '{}' finished", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNSUBSCRIBE_CALLBACK_FAILED(50006008, "Failed to call SaaS Provisioning service after unsubscribe request of tenant '{}' finished", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TENANT_READ_FAILED(50006010, "Failed to read tenant ids", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EDMX_READ_FAILED(50006011, "Failed to read EDMX for service '{}' from MTX sidecar", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MT_LIB_SETUP_FAILED(50006012, "Could not setup multi tenancy library: '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_UNIQUE_DATASOURCE_SERVICE(50006013, "Failed to determine a unique service binding to configure the primary datasource. Please specify cds.dataSource.binding", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CLOUDEVENTS_MESSAGE(50007002, "Failed to parse message as CloudEvents message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_BROKER_CONFIGURATION(50007006, "Invalid messaging broker configuration for service '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_PROCESSING_FAILED(50007009, "Failed to process event '{}' on service '{}' received on queue '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EVENT_EMITTING_FAILED(50007011, "Failed to send message to topic '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_WEBHOOK_URL(50007012, "Failed to determine application URL for webhook registration", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_TENANT_INFO(50007013, "Required tenant information is missing in the request context", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNKNOWN_TENANT(50007014, "Could not determine subdomain for tenant '{}'", (ErrorStatus)ErrorStatuses.NOT_FOUND),
    TENANT_ADMIN_FORBIDDEN(50007015, "Not authorized for enterprise-messaging tenant management", (ErrorStatus)ErrorStatuses.FORBIDDEN),
    UPDATE_TENANT_IS_RUNNING(50007016, "The tenant update is currently running", (ErrorStatus)ErrorStatuses.CONFLICT),
    TENANT_SYNC_SUBSCRIBE_FORBIDDEN(50007017, "Only asynchronous SaaS subscription is supported when using enterprise-messaging with multitenancy", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MULTIPLE_MESSAGINGSERVICE(50007019, "Multiple messaging services found: Consider configuring the composite messaging service", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_DATA_FORMAT(50007020, "Invalid data structure of the remote event which is not matching the CDS event definition '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_SSL_CONTEXT(50007021, "Failed to create the mTLS context", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    ACKNOWLEDGMENT_FAILED(50007022, "Failed to acknowledge message with topic '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_MESSAGE_PROVIDED(50007024, "Neither data nor headers are set", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_KAFKA_CLUSTER_PROVIDED(50007025, "The Kafka cluster could not be determined from the Kafka credentials", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TENANT_NOT_EXISTS(50007030, "Tenant '{}' is not subscribed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    TOPIC_CREATION_FAILED(50007031, "Failed to create topic '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EM_SUBSCRIPTION_FAILED(50007032, "Failed to process enterprise-messaging subscription of tenant '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    EM_UPGRADE_FAILED(50007033, "Failed to process enterprise-messaging upgrade for tenant(s) '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_METADATA(50008001, "Could not load a valid OData V4 metadata file for service '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESPONSE_SERIALIZATION_FAILED(50008002, "Failed to serialize response payload", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    DESERIALIZER_FAILED(50008003, "Failed to create deserializer", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SERIALIZER_FAILED(50008004, "Failed to create serializer", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNEXPECTED_URI_RESOURCE(50008005, "Unexpected URI resource type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNEXPECTED_EDM_TYPE(50008006, "Unexpected EDM type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    ORDERBY_PARSING_FAILED(50008007, "Failed to transform $orderby to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    FILTER_PARSING_FAILED(50008008, "Failed to transform $filter to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SELECT_PARSING_FAILED(50008009, "Failed to transform $select to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MISSING_VALUE_FOR_COUNT(50008010, "The query result misses a value for $count", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    VALUE_PARSING_FAILED(50008011, "Failed to transform expression to CQN value", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNEXPECTED_PROPERTY_TYPE(50008013, "Unexpected EDM property type '{}' of property '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MISSING_BINDING_TARGET(50008014, "Missing EdmBindingTarget of EDM type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    WRONG_BASE_EDM_TYPE(50008015, "Wrong base EDM type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_I18N_RESOURCES_FORMAT(50008016, "The EDMX I18N resources '{}' could not be loaded", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    X4_UNSUPPORTED(50008017, "OData X4 is only supported with Universal CSN enabled", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SEARCH_PARSING_FAILED(50009001, "Failed to transform custom 'search' option to CQN", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_METADATA_V2(50009002, "File '{}' is not a valid V2 metadata file", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    RESOLVING_FUNCTION_IMPORT_ANNOTATION_FAILED(50009003, "Failed to resolve annotations for function import '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MISSING_EDM_PROPERTY(50009004, "Failed to get EDM property '{}' from EDM entity/type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_METADATA_V2_DYNAMIC(50009005, "Dynamic model provider did not respond with a valid V2 metadata file for service '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    VALUE_CONVERSION_FAILED(50009006, "Could not convert value '{}' of type '{}' to EDM type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_INVALIDHEADER(50010003, "CSV file '{}' has header line with multiple delimiters", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_UNKNOWNCOLUMN(50010004, "CSV file '{}' has column '{}' which does not exist on entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CSV_FILE_TYPEMISMATCH(50010005, "Value '{}' does not match type '{}' of column '{}' in CSV file '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CONFIGURER_COMPLETED(50011001, "The CDS runtime configurer is already completed: Changes to the underlying CDS runtime are no longer allowed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_CONFIGURATION_PHASE(50011002, "An operation of phase '{}' is not allowed anymore, as the CDS runtime configurer is already in phase '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_PATH_EXPR(50012001, "Could not transform CQN to OData request: Accessing elements through path expressions is not supported by the OData protocol", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_REF_TYPE(50012003, "Could not transform CQN to OData request: Failed to determine the type of the reference '{}' in entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_TYPE_CONV(50012004, "Could not convert object '{}' of type '{}' to CDS base type '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_ERROR_RESPONSE(50012005, "The remote OData service responded with status code '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_FUNCTION(50012006, "Could not transform CQN to OData request: The function '{}' is not supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_NUM_ARGS(50012007, "Could not transform CQN to OData request: Wrong number of arguments was provided for function '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_OPERATOR(50012008, "Could not transform CQN to OData request: The operator '{}' is used incorrectly", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_FUNCTION_VERSION(50012009, "Could not transform CQN to OData request: The function '{}' is not supported for OData version '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_V2_LAMBDA(50012010, "Could not transform CQN to OData request: Lambda operators are not supported in OData V2", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_JSON_SERIALIZATION(50012011, "Could not serialize entry to OData compatible JSON", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_ONLY_COLLECTION(50012012, "Could not transform CQN to OData request: POST requests are only supported on collections", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_ONLY_ENTITY(50012013, "Could not transform CQN to OData request: PATCH/DELETE requests are only supported on single entities", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_INCOMPLETE_KEY(50012014, "Could not transform CQN to OData request: Could not retrieve values for all keys of entity '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_INVALID_LAMBDA_ALL(50012015, "Could not transform CQN to OData request: Lambda 'all' statements without argument are not supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_MISSING_STATEMENT(50012016, "Could not transform CQN to OData request: CQN Select Statement defining the target of the operation is missing", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_ODATA_EMPTY_SELECTION(50012017, "Could not transform CQN to OData request: Empty select list. All elements have been excluded.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_SERVICE_IN_CATALOG(50013001, "Could not find destination service with name '{}', configured for composite service '{}', in the service catalog", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_DESTINATION_SERVICE(50013002, "No destination service defined for the event '{}' in the composite service configuration '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_SECRETS_PATH(50014001, "Secrets path '{}' of service binding '{}' is not a directory", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_PROPERTY_FILE(50014002, "Could not read property file '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    APP_PROPERTIES_UNSUPPORTED(50014003, "Kubernetes does not provide an application name or ID", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    MULTIPLE_APPLICATION_URLS(50015001, "Cannot determine the application url because multiple URIs are provided by VCAP_APPLICATION", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_NOT_AVAILABLE(50016001, "Auditlog service is not reachable", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_INVALID_MESSAGE(50016002, "Invalid auditlog message: {}", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_INVALID_CONFIG(50016003, "Auditlog service configuration is invalid, parameter '{}' is missing", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_NO_USER(50016004, "User information is missing, can't log audit message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_SERVICE_INVALID_PLAN(50016005, "Auditlog service plan '{}' not supported", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_AUDITLOG_MODEL(50016006, "Auditlog model '{}' is not available", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_NOT_READABLE(50016007, "Auditlog model '{}' is not readable", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_DATA_SUBJECT_MISSING(50016008, "A data subject for entity '{}' is missing, can't log audit message", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    AUDITLOG_UNEXPECTED_HTTP_STATUS(50016010, "Audit Log service returned with unexpected status code {}", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CONTEXT_SERIALIZATION_FAILED(50017001, "Failed to serialize the event context of event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CONTEXT_DESERIALIZATION_FAILED(50017002, "Failed to deserialize the outbox message of outbox event '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    OUTBOX_SERVICE_NOT_OUTBOXABLE(50017003, "The outbox service '{}' cannot be outboxed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    SERVICE_HAS_NO_SERVICESPI(50017004, "The service '{}' does not implement ServiceSPI and can't be outboxed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    ASYNC_SERVICE_INTERFACE_DECLARES_UNKNOWN_METHOD(50017005, "The async service interface '{}' declares the method(s) '{}' which aren't available in service '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    ASYNC_INTERFACE_NO_INTERFACE(50017006, "The class '{}' must be an interface", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_HCQL_ERROR_RESPONSE(50018001, "Remote HCQL service responded with HTTP status code '{}', error code '{}' and message '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_HCQL_COMMUNICATION_FAILED(50018002, "Remote HCQL communication failed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_HCQL_UNEXPECTED_ROWCOUNTS(50018003, "Remote HCQL response contains unexpected number of row counts", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_HCQL_CQN_SELECT_MISSING(50018004, "Calling the bound action / function '{}' requires a CQN select statement.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_HCQL_INVALID_RESPONSE(50018005, "The HCQL response is invalid.", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    PDF_SERVICE_NOT_AVAILABLE(50019001, "No PDF export service available", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    ERROR_GENERATING_PDF(50019002, "Failed to generate PDF", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NO_PDF_DESC_HEADER(50019003, "No PDF descriptor provided to generate a document", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    INVALID_PDF_DESC_HEADER(50019004, "Invalid PDF descriptor header", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    CERT_ISSUER_SUBJECT_NOT_SET(50020002, "The issuer and/or subject of the certificate is not configured for UCL", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UCL_DESTINATION_NOT_DEFINED(50020003, "Request for asynchronous SPII flow cannot be completed because no destination name defined in `cds.ucl.destination`", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_RFC_ABAP_EXCEPTION(50021001, "An error occurred in remote ABAP server while processing RFC '{}' at destination '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    REMOTE_RFC_EXCEPTION(50021002, "An error occurred while processing a remote RFC '{}' at destination '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    BAPI_TRANSACTION_COMMIT_FAILED(50021003, "RFC transaction commit for destination '{}' failed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    BAPI_TRANSACTION_ROLLBACK_FAILED(50021004, "RFC transaction rollback for destination '{}' failed", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    ERROR_READING_ORD_DOCUMENT(50022001, "Error reading ORD document from path '{}'", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    NAMESPACE_NOT_FOUND(50022002, "System Namespace could not be retrieved from Event Hub binding", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    PACKAGE_ORDID_NOT_FOUND(50022003, "Package ordId could not be retrieved", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    PACKAGE_VERSION_NOT_FOUND(50022004, "Package version could not be retrieved", (ErrorStatus)ErrorStatuses.SERVER_ERROR),
    UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE(501001, "Action or function return values of type '{}' are not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_METHOD(501002, "Method '{}' is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_OPERATOR(501003, "Operator '{}' is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_EXPAND_ALL_IN_DRAFT(501004, "Expanding all fields on a draft enabled entity is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_PATH_IN_DRAFT(501005, "Expanding or inlining a draft enabled entity via a path is not supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_APPLY_OPTION(501006, "Apply option '{}' is not yet supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_CONCAT_LAST(501007, "'concat' is currently only supported as the last transformation of $apply", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_CONCAT_SYSTEMQUERY(501008, "Transformation 'concat' with system query option {} is not supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_RESTRICTION(501009, "Restriction on CDS model element '{}' of type {} is not supported", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED),
    UNSUPPORTED_TABLE_FUNCTION(501010, "Table Functions are only supported on PersistenceService", (ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED);

    private final int code;
    private final String description;
    private final ErrorStatus httpError;
    private final String descriptionForTranslation;
    private final String translationHint;

    private CdsErrorStatuses(int code, String description, ErrorStatus httpError) {
        this(code, description, null, null, httpError);
    }

    private CdsErrorStatuses(int code, String description, String descriptionForTranslation, ErrorStatus httpError) {
        this(code, description, descriptionForTranslation, descriptionForTranslation, httpError);
    }

    private CdsErrorStatuses(int code, String description, String descriptionForTranslation, String translationHint, ErrorStatus httpError) {
        this.code = code;
        this.description = description;
        this.descriptionForTranslation = descriptionForTranslation;
        this.translationHint = translationHint;
        this.httpError = httpError;
    }

    public String getCodeString() {
        return Integer.toString(this.code);
    }

    public String getDescription() {
        return this.description;
    }

    public int getHttpStatus() {
        return this.httpError.getHttpStatus();
    }

    public ErrorStatus getHttpError() {
        return this.httpError;
    }

    public String getDescriptionForTranslation() {
        return this.descriptionForTranslation;
    }

    public String getTranslationHint() {
        return this.translationHint;
    }
}

