/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.lib.tools.api;

import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import com.sap.cds.services.utils.lib.tools.impl.Retry;
import com.sap.cds.services.utils.lib.tools.impl.WaitTimeFunction;
import java.time.Duration;
import java.util.function.BooleanSupplier;

public class ResilienceConfig {
    public static final ResilienceConfig NONE = new ResilienceConfig(0, Duration.ZERO, WaitTimeCalculation.CONSTANT);
    private int numOfRetries;
    private Duration baseWaitTime;
    private WaitTimeCalculation waitTimeCalculation = WaitTimeCalculation.CONSTANT;

    public ResilienceConfig() {
    }

    protected ResilienceConfig(int numOfRetries, Duration baseWaitTime, WaitTimeCalculation waitTimeCalculation) {
        this.numOfRetries = numOfRetries;
        this.baseWaitTime = baseWaitTime;
        this.waitTimeCalculation = waitTimeCalculation != null ? waitTimeCalculation : WaitTimeCalculation.CONSTANT;
    }

    public void setRetryInterval(Duration retryInterval) {
        throw new IllegalArgumentException("Parameter retry Interval is not supported anymore.");
    }

    public int getNumOfRetries() {
        return this.numOfRetries;
    }

    public Duration getBaseWaitTime() {
        return this.baseWaitTime;
    }

    public void setNumOfRetries(int numOfRetries) {
        this.numOfRetries = numOfRetries;
    }

    public void setBaseWaitTime(Duration baseWaitTime) {
        this.baseWaitTime = baseWaitTime;
    }

    public WaitTimeCalculation getWaitTimeCalculation() {
        return this.waitTimeCalculation;
    }

    public void setWaitTimeCalculation(WaitTimeCalculation waitTimeCalculation) {
        this.waitTimeCalculation = waitTimeCalculation;
    }

    public static ResilienceConfigBuilder builder() {
        return new ResilienceConfigBuilder();
    }

    public boolean waitFor(BooleanSupplier finished) {
        WaitTimeFunction waitTimeFunction = this.getWaitTimeFunction();
        Retry retry = Retry.RetryBuilder.create().numOfRetries(this.numOfRetries).baseWaitTime(this.baseWaitTime).waitTimeFunction(waitTimeFunction).retryExceptions(InternalException.class).build();
        try {
            return retry.execute(() -> {
                if (finished.getAsBoolean()) {
                    return true;
                }
                throw new InternalException("Not finished yet.");
            });
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean tryWhile(BooleanSupplier whileCond) {
        return this.waitFor(() -> !whileCond.getAsBoolean());
    }

    public WaitTimeFunction getWaitTimeFunction() {
        return switch (this.waitTimeCalculation) {
            case WaitTimeCalculation.CONSTANT -> Retry.CONSTANT_WAIT_TIME_FUNCTION;
            case WaitTimeCalculation.LINEAR -> Retry.LINEAR_WAIT_TIME_FUNCTION;
            case WaitTimeCalculation.EXP -> Retry.EXP_WAIT_TIME_FUNCTION;
            default -> Retry.CONSTANT_WAIT_TIME_FUNCTION;
        };
    }

    public static enum WaitTimeCalculation {
        LINEAR,
        EXP,
        CONSTANT;

    }

    public static final class ResilienceConfigBuilder {
        private int numOfRetries;
        private Duration baseWaitTime;
        private WaitTimeCalculation waitTimeCalculation = WaitTimeCalculation.CONSTANT;

        private ResilienceConfigBuilder() {
        }

        public ResilienceConfigBuilder numOfRetries(int numOfRetries) {
            this.numOfRetries = numOfRetries;
            return this;
        }

        public ResilienceConfigBuilder baseWaitTime(Duration baseWaitTime) {
            this.baseWaitTime = baseWaitTime;
            return this;
        }

        public ResilienceConfigBuilder waitTimeCalculation(WaitTimeCalculation waitTimeCalculation) {
            this.waitTimeCalculation = waitTimeCalculation;
            return this;
        }

        public ResilienceConfig build() {
            return new ResilienceConfig(this.numOfRetries, this.baseWaitTime, this.waitTimeCalculation);
        }
    }
}

