/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.environment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VcapServicesParser {
    public static final String VCAP_SERVICES = "VCAP_SERVICES";
    private static final Logger logger = LoggerFactory.getLogger(VcapServicesParser.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="binding_name")
    private String bindingName;
    @JsonProperty(value="instance_name")
    private String instanceName;
    @JsonProperty(value="plan")
    private String servicePlan;
    @JsonProperty(value="tags")
    private List<String> tags;
    @JsonProperty(value="credentials")
    private Map<String, Object> credentials;

    public static List<ServiceBinding> getServiceBindings(String vcapServices) {
        ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
        if (vcapServices != null && vcapServices.trim().length() > 0) {
            try {
                JsonNode vcapNodes = mapper.readTree(vcapServices);
                if (vcapNodes.has(VCAP_SERVICES)) {
                    vcapNodes = vcapNodes.get(VCAP_SERVICES);
                }
                vcapNodes.properties().forEach(serviceField -> {
                    Iterator bindingNodes = ((JsonNode)serviceField.getValue()).elements();
                    int i = 0;
                    while (bindingNodes.hasNext()) {
                        try {
                            VcapServicesParser parseBinding = (VcapServicesParser)mapper.treeToValue((TreeNode)bindingNodes.next(), VcapServicesParser.class);
                            DefaultServiceBinding binding = DefaultServiceBinding.builder().copy(Collections.emptyMap()).withName(parseBinding.getName()).withServiceName((String)serviceField.getKey()).withServicePlan(parseBinding.servicePlan).withTags(parseBinding.tags != null ? parseBinding.tags : Collections.emptyList()).withCredentials(parseBinding.credentials != null ? parseBinding.credentials : Collections.emptyMap()).build();
                            bindings.add((ServiceBinding)binding);
                        }
                        catch (IOException e) {
                            logger.warn("Could not parse service binding of service '{}' at index '{}'.", new Object[]{serviceField.getKey(), i, e});
                        }
                        ++i;
                    }
                });
            }
            catch (IOException e) {
                logger.warn("Could not parse VCAP_SERVICES", (Throwable)e);
            }
        }
        return bindings;
    }

    private String getName() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.bindingName != null && !this.bindingName.isEmpty()) {
            return this.bindingName;
        }
        if (this.instanceName != null && !this.instanceName.isEmpty()) {
            return this.instanceName;
        }
        return null;
    }
}

