/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.mt.ExtensibilityService;
import com.sap.cds.services.mt.ModelChangedEventContext;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.IdentityUtils;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.lib.mtx.MetaDataAccessor;
import com.sap.cds.services.utils.lib.mtx.ModelId;
import com.sap.cds.services.utils.lib.mtx.impl.CacheParams;
import com.sap.cds.services.utils.lib.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.services.utils.lib.mtx.impl.ModelProviderAccess;
import com.sap.cds.services.utils.lib.tools.api.ResilienceConfig;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.BtpServiceOptions;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationLoader;
import com.sap.cloud.sdk.cloudplatform.connectivity.ServiceBindingDestinationOptions;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicModelUtils {
    private static final Logger logger = LoggerFactory.getLogger(DynamicModelUtils.class);
    private final CdsRuntime runtime;
    private final CdsProperties.Model.Provider providerConfig;
    private final CdsProperties.MultiTenancy.Sidecar sidecarConfig;
    private final IdentityUtils identityUtils;

    public DynamicModelUtils(CdsRuntime runtime) {
        this.runtime = runtime;
        this.providerConfig = runtime.getEnvironment().getCdsProperties().getModel().getProvider();
        this.sidecarConfig = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getSidecar();
        this.identityUtils = new IdentityUtils(runtime);
    }

    public boolean useStaticModel() {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        return this.useStaticModel(requestContext.getUserInfo(), requestContext.getFeatureTogglesInfo());
    }

    public boolean useStaticModel(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        boolean hasAllToggles = featureTogglesInfo.getEnabledFeatureToggles().anyMatch(t -> t.getName().trim().equals("*"));
        return !(this.providerConfig.isExtensibility() && userInfo.getTenant() != null || this.providerConfig.isToggles() && !hasAllToggles);
    }

    public ModelId.Builder prepareModelId(UserInfo userInfo, FeatureTogglesInfo featureTogglesInfo) {
        String tenant = this.providerConfig.isExtensibility() ? userInfo.getTenant() : null;
        Set<String> features = this.providerConfig.isToggles() ? featureTogglesInfo.getEnabledFeatureToggles().map(ft -> ft.getName()).collect(Collectors.toSet()) : Collections.emptySet();
        return ModelId.create(tenant).features(features);
    }

    public boolean isModelProviderEnabled() {
        return !StringUtils.isEmpty(this.getModelProviderUrl()) && (this.providerConfig.isExtensibility() || this.providerConfig.isToggles());
    }

    public String getModelProviderUrl() {
        return !StringUtils.isEmpty(this.providerConfig.getUrl()) ? this.providerConfig.getUrl() : this.sidecarConfig.getUrl();
    }

    public <T> MetaDataAccessor<T> createMetadataAccessor(MetaDataAccessorImpl.EdmxModelCreator<T> strToEdmx, MetaDataAccessorImpl.CdsModelCreator strToModel, MetaDataAccessorImpl.I18nResourceCreator strToI18n) {
        ExtensibilityService extService;
        ModelProviderAccess sidecarAccess = new ModelProviderAccess(request -> {}, this.getResilienceConfig());
        CacheParams cacheParams = this.getCacheParams(this.providerConfig.getCache());
        MetaDataAccessorImpl accessor = new MetaDataAccessorImpl(new MetaDataAccessorImpl.MetaDataAccessorConfig.Builder().sidecarAccess(sidecarAccess).cacheParams(cacheParams).strToEdmx(strToEdmx).strToModel(strToModel).strToI18n(strToI18n).build(), null);
        if (accessor != null && (extService = (ExtensibilityService)this.runtime.getServiceCatalog().getService(ExtensibilityService.class, "ExtensibilityService$Default")) != null) {
            extService.on("MODEL_CHANGED", null, context -> {
                String tenant = context.getUserInfo().getTenant();
                Instant changedAt = ((ModelChangedEventContext)context.as(ModelChangedEventContext.class)).getTimestamp();
                int maxAge = changedAt == null ? 0 : (int)Duration.between(changedAt, Instant.now()).toSeconds();
                accessor.refresh(tenant, maxAge);
            });
        }
        return accessor;
    }

    private CacheParams getCacheParams(CdsProperties.Model.Provider.Cache cache) {
        long maximumSize = cache.getMaxSize();
        long expirationDuration = cache.getExpirationTime();
        long refreshDuration = cache.getRefreshTime();
        return new CacheParams(maximumSize, Duration.ofSeconds(expirationDuration), Duration.ofSeconds(refreshDuration), false, false);
    }

    public ResilienceConfig getResilienceConfig() {
        return ResilienceConfig.builder().numOfRetries(3).baseWaitTime(Duration.ofMillis(500L)).waitTimeCalculation(ResilienceConfig.WaitTimeCalculation.LINEAR).build();
    }

    public HttpDestination createSidecarDestination(String destinationName, String targetUrl) {
        ServiceBinding binding;
        List<ServiceBinding> uaaBindings = this.identityUtils.getXsuaaServiceBindings();
        if (!uaaBindings.isEmpty()) {
            binding = uaaBindings.get(0);
        } else if (!this.identityUtils.getIasServiceBindings().isEmpty()) {
            binding = this.identityUtils.getIasServiceBindings().get(0);
        } else {
            logger.debug("Initializing MTX sidecar destination '{}' without service binding.", (Object)destinationName);
            return DefaultHttpDestination.builder((String)targetUrl).name(destinationName).build();
        }
        logger.debug("Initializing MTX sidecar destination '{}' using service binding '{}'.", (Object)destinationName, binding.getName().get());
        DefaultHttpDestination http = (DefaultHttpDestination)ServiceBindingDestinationLoader.defaultLoaderChain().getDestination(ServiceBindingDestinationOptions.forService((ServiceBinding)binding).withOption(BtpServiceOptions.AuthenticationServiceOptions.withTargetUri((String)targetUrl)).onBehalfOf(OnBehalfOf.TECHNICAL_USER_PROVIDER).build());
        return DefaultHttpDestination.fromDestination((Destination)http).name(destinationName).build();
    }
}

