/*
 * © 2021-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;

public class ExecutorUtils {
  private ExecutorUtils() {}

  /**
   * Runs the {@code runnable} asynchronously in the current {@link RequestContext}. The thread is
   * started as non daemon.
   *
   * @param runnable the {@link Runnable} to execute
   */
  public static void runAsynchronously(CdsRuntime runtime, Runnable runnable) {
    RequestContextRunner runner = runtime.requestContext();
    Thread asyncThread =
        new Thread(
            () ->
                runner.run(
                    requestContext -> {
                      runnable.run();
                    }));
    asyncThread.setDaemon(false);
    asyncThread.start();
  }
}
