/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.index;

import com.sap.cds.adapter.IndexContentProvider;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class IndexPageServlet extends HttpServlet {

  private static final long serialVersionUID = 1L;

  private static final String HEADER =
      """
      <!DOCTYPE html>
          <html>
              <head>
                  <meta name="color-scheme" content="dark light">
                  <style>
      """;

  private static final String BODY =
      """
                  </style>
              </head>
              <body>
                <div id="welcome">
                  <h1> Welcome to <i>CAP Java</i> </h1>
                  <p> These are the paths currently served &hellip;
                  <p></p>
      """;

  private static final String SECTION_TITLE =
      """
                  <br>
                  <h2>%s</h2>
      """;

  private static final String END =
      """
                 </div><br><br><br>
              </body>
          </html>
      """;

  private List<IndexContentProvider> contentProviders;

  public IndexPageServlet(List<IndexContentProvider> contentProviders) {
    this.contentProviders = Collections.unmodifiableList(contentProviders);
  }

  @Override
  protected void service(HttpServletRequest req, HttpServletResponse resp)
      throws ServletException, IOException {
    resp.setContentType("text/html");

    PrintWriter out = resp.getWriter();
    out.write(HEADER);
    out.write(loadCss());
    out.write(BODY);

    String contextPath =
        getServletConfig() == null
            ? req.getContextPath()
            : getServletConfig().getServletContext().getContextPath();

    for (IndexContentProvider provider : contentProviders) {
      out.format(SECTION_TITLE, provider.getSectionTitle());
      provider.writeContent(out, contextPath);
    }

    out.write(END);
  }

  private String loadCss() throws IOException {

    InputStream in =
        this.getClass().getClassLoader().getResourceAsStream("com.sap.cds/index-page/styles.css");

    int bufferSize = 1024;
    char[] buffer = new char[bufferSize];
    StringBuilder imports = new StringBuilder();
    Reader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
    for (int numRead; (numRead = reader.read(buffer, 0, buffer.length)) > 0; ) {
      imports.append(buffer, 0, numRead);
    }

    return imports.toString();
  }
}
