/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.mt;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsException;
import com.sap.cds.SessionContext;
import com.sap.cds.reflect.CdsModel;
import java.util.function.Supplier;

public class TenantAwareCdsDataStoreConnector implements CdsDataStoreConnector {
  private final CdsDataStoreLookup cdsDataStoreLookup;
  private final Supplier<String> tenantProvider;

  public TenantAwareCdsDataStoreConnector(
      CdsDataStoreLookup cdsDataStoreLookup, Supplier<String> tenantProvider) {
    this.cdsDataStoreLookup = cdsDataStoreLookup;
    this.tenantProvider = tenantProvider;
  }

  @Override
  public CdsDataStore connect() throws CdsException {
    return getConnector().connect();
  }

  @Override
  public CdsModel reflect() throws CdsException {
    return getConnector().reflect();
  }

  private CdsDataStoreConnector getConnector() {
    cdsDataStoreLookup.evictIfOutDated(tenantProvider.get());
    return cdsDataStoreLookup.getCdsDataStoreConnector(tenantProvider.get());
  }

  @Override
  public CdsDataStore connect(SessionContext session) {
    return getConnector().connect(session);
  }

  @Override
  public Capabilities capabilities() {
    return getConnector().capabilities();
  }
}
