/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.tools.api;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CodeTools {
  private CodeTools() {}

  public static <T> Code<T> code(T theCode) {
    return new Code<>(theCode);
  }

  @SuppressWarnings("unchecked")
  public static class Code<T> {
    private final T theCode;

    private Code(T theCode) {
      this.theCode = theCode;
    }

    public boolean in(T... entries) {
      Set<T> set = new HashSet<>();
      Arrays.stream(entries).forEach(set::add);
      return set.contains(theCode);
    }

    public boolean notIn(T... entries) {
      return !in(entries);
    }
  }
}
