/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.lib.tools.api;

import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import java.util.List;
import java.util.Map;

public interface ServiceCallMediators {
  /*
  create|http | get   | payload        |pathParameter   |-->| query     |-->|enhancer|    -->  |------------------> | end
      |     | put   | withoutPayload | noPathParameter|   | noQuery   |   |noEnhancer|       | insertHeaderFields | end
        | post  |
        | delete|
        | patch |
  */
  public interface FromCreate {
    FromHttp http();
  }

  public interface FromHttp {
    FromHttpMethod get();

    FromHttpMethod put();

    FromHttpMethod post();

    FromHttpMethod delete();

    FromHttpMethod patch();
  }

  public interface FromHttpMethod {
    <P> FromPayload payload(P payload);

    FromPayload withoutPayload();
  }

  public interface FromPayload {
    FromPathParameter pathParameter(String... path);

    FromPathParameter noPathParameter();
  }

  public interface FromPathParameter {
    FromQuery query(List<QueryParameter> queryParameters);

    FromQuery noQuery();
  }

  public interface FromQuery extends End {
    End insertHeaderFields(Map<String, String> headerFields);
  }

  public interface End {
    ServiceCall end() throws InternalException;
  }
}
