/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.reflect.CdsAnnotatable;
import java.util.Map;

public class StreamUtils {

  private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

  private StreamUtils() {
    // hidden
  }

  public static String getCoreMediaTypeElement(CdsAnnotatable annotatable) {
    // TODO check defaulting
    return getAnnotationElement(CdsAnnotations.CORE_MEDIA_TYPE, annotatable);
  }

  public static String getCoreMediaTypeValue(CdsAnnotatable annotatable) {
    return CdsAnnotations.CORE_MEDIA_TYPE.isTrue(annotatable)
        ? APPLICATION_OCTET_STREAM
        : getAnnotationValue(CdsAnnotations.CORE_MEDIA_TYPE, annotatable);
  }

  public static String getContentDispositionFilenameElement(CdsAnnotatable annotatable) {
    return getAnnotationElement(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, annotatable);
  }

  public static String getContentDispositionFilenameValue(CdsAnnotatable annotatable) {
    return getAnnotationValue(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, annotatable);
  }

  public static String getContentDispositionTypeValue(CdsAnnotatable annotatable) {
    return getAnnotationValue(CdsAnnotations.CORE_CONTENT_DISPOSITION_TYPE, annotatable);
  }

  private static String getAnnotationElement(
      CdsAnnotations annotation, CdsAnnotatable annotatable) {
    return annotatable != null && annotation.getOrDefault(annotatable) instanceof Map<?, ?> m
        ? (String) m.get("=")
        : null;
  }

  private static String getAnnotationValue(CdsAnnotations annotation, CdsAnnotatable annotatable) {
    return annotatable != null && annotation.getOrDefault(annotatable) instanceof String s
        ? s
        : null;
  }
}
