/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.ResolvedSegment;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Iterator;
import java.util.Map;

public class DraftUtils {
    private DraftUtils() {
    }

    public static boolean isDraftEnabled(String serviceName, CdsModel model) {
        return model.findService(serviceName).map(s -> s.entities().anyMatch(e -> DraftUtils.isDraftEnabled((CdsAnnotatable)e))).orElse(false);
    }

    public static boolean isDraftTarget(CqnStructuredTypeRef ref, CdsEntity entity, CdsModel model) {
        if (DraftUtils.isDraftEnabled((CdsAnnotatable)entity)) {
            Iterator segments = CqnAnalyzer.create((CdsModel)model).analyze(ref).reverse();
            while (segments.hasNext()) {
                Map targetKeys = ((ResolvedSegment)segments.next()).keyValues();
                if (targetKeys.isEmpty()) continue;
                return Boolean.FALSE.equals(targetKeys.get("IsActiveEntity"));
            }
        }
        return false;
    }

    public static boolean isDraftEnabled(CdsAnnotatable entity) {
        return CdsAnnotations.DRAFT_ANNOTATION.isTrue(entity) || CdsAnnotations.DRAFT_PREPARE_ANNOTATION.getOrDefault(entity) != null;
    }

    public static boolean isDraftRoot(CdsAnnotatable entity) {
        return CdsAnnotations.DRAFT_ANNOTATION.isTrue(entity);
    }
}

