/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.hcql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sap.cds.impl.parser.StructDataParser;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsTypeUtils;
import java.util.Optional;

public class HcqlUtils {
    private HcqlUtils() {
    }

    public static Object convertToType(CdsType type, ObjectNode node, String name) {
        if (type.isSimple()) {
            CdsBaseType baseType = ((CdsSimpleType)type.as(CdsSimpleType.class)).getType();
            Optional<String> fieldValue = HcqlUtils.getValueAsString(node, name);
            if (fieldValue.isPresent()) {
                return CdsTypeUtils.parse((CdsBaseType)baseType, (String)fieldValue.get());
            }
            return null;
        }
        if (type.isStructured()) {
            return StructDataParser.parseObjectOf((CdsStructuredType)((CdsStructuredType)type.as(CdsStructuredType.class)), (ObjectNode)((ObjectNode)node.get(name)));
        }
        if (type.isArrayed()) {
            CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
            if (itemsType.isSimple()) {
                return StructDataParser.parseArrayOf((CdsSimpleType)((CdsSimpleType)itemsType.as(CdsSimpleType.class)), (ArrayNode)((ArrayNode)node.get(name)));
            }
            if (itemsType.isStructured()) {
                return StructDataParser.parseArrayOf((CdsStructuredType)((CdsStructuredType)itemsType.as(CdsStructuredType.class)), (ArrayNode)((ArrayNode)node.get(name)));
            }
        }
        return null;
    }

    public static String getValueAsString(ObjectNode node, String name, String defaultValue) {
        return HcqlUtils.getValueAsString(node, name).orElse(defaultValue);
    }

    public static Optional<String> getValueAsString(ObjectNode node, String name) {
        JsonNode child = node.get(name);
        if (child != null && !child.isNull()) {
            return Optional.of(child.isValueNode() ? child.asText() : child.toString());
        }
        return Optional.empty();
    }
}

