/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.lib.tools.impl;

import com.sap.cds.services.utils.lib.tools.api.HttpMethod;
import com.sap.cds.services.utils.lib.tools.api.QueryParameter;
import com.sap.cds.services.utils.lib.tools.api.ServiceCall;
import com.sap.cds.services.utils.lib.tools.api.ServiceCallMediators;
import com.sap.cds.services.utils.lib.tools.api.ServiceEndpoint;
import com.sap.cds.services.utils.lib.tools.exception.InternalException;
import com.sap.cds.services.utils.lib.tools.impl.ServiceCallImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ServiceCallBuilder
implements ServiceCallMediators.FromCreate,
ServiceCallMediators.FromHttp,
ServiceCallMediators.FromHttpMethod,
ServiceCallMediators.FromPayload,
ServiceCallMediators.FromPathParameter,
ServiceCallMediators.FromQuery {
    private ServiceEndpoint serviceEndpoint = null;
    private final Map<String, String> headerFields = new HashMap<String, String>();
    private final List<QueryParameter> queryParameters = new ArrayList<QueryParameter>();
    private Object payload = null;
    private List<String> pathParameters = new ArrayList<String>();
    private HttpMethod httpMethod;

    private ServiceCallBuilder(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public ServiceCallMediators.FromHttp http() {
        return this;
    }

    @Override
    public ServiceCallMediators.FromHttpMethod get() {
        this.httpMethod = HttpMethod.GET;
        return this;
    }

    @Override
    public ServiceCallMediators.FromHttpMethod put() {
        this.httpMethod = HttpMethod.PUT;
        return this;
    }

    @Override
    public ServiceCallMediators.FromHttpMethod post() {
        this.httpMethod = HttpMethod.POST;
        return this;
    }

    @Override
    public ServiceCallMediators.FromHttpMethod delete() {
        this.httpMethod = HttpMethod.DELETE;
        return this;
    }

    @Override
    public ServiceCallMediators.FromHttpMethod patch() {
        this.httpMethod = HttpMethod.PATCH;
        return this;
    }

    @Override
    public <P> ServiceCallMediators.FromPayload payload(P payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public ServiceCallMediators.FromPayload withoutPayload() {
        return this;
    }

    @Override
    public ServiceCallMediators.FromPathParameter pathParameter(String ... pathParameters) {
        this.pathParameters = Arrays.asList(pathParameters);
        return this;
    }

    @Override
    public ServiceCallMediators.FromPathParameter noPathParameter() {
        return this;
    }

    @Override
    public ServiceCallMediators.FromQuery query(List<QueryParameter> queryParameters) {
        if (queryParameters != null) {
            this.queryParameters.addAll(queryParameters);
        }
        return this;
    }

    @Override
    public ServiceCallMediators.FromQuery noQuery() {
        return this;
    }

    @Override
    public ServiceCallMediators.End insertHeaderFields(Map<String, String> headerFields) {
        this.headerFields.putAll(headerFields);
        return this;
    }

    public static ServiceCallMediators.FromCreate createBuilder(ServiceEndpoint serviceEndpoint) {
        return new ServiceCallBuilder(serviceEndpoint);
    }

    @Override
    public ServiceCall end() throws InternalException {
        if (this.serviceEndpoint == null) {
            throw new InternalException("No service endpoint specified");
        }
        if (this.pathParameters != null) {
            for (String pathParameter : this.pathParameters) {
                if (!StringUtils.isBlank((CharSequence)pathParameter)) continue;
                throw new InternalException("An empty path parameter was specified for service " + this.serviceEndpoint.getPath());
            }
        }
        return new ServiceCallImpl(this.httpMethod, this.serviceEndpoint, this.pathParameters, this.payload, this.headerFields, this.queryParameters);
    }
}

