/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.model;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Map;

public class StreamUtils {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    private StreamUtils() {
    }

    public static String getCoreMediaTypeElement(CdsAnnotatable annotatable) {
        return StreamUtils.getAnnotationElement(CdsAnnotations.CORE_MEDIA_TYPE, annotatable);
    }

    public static String getCoreMediaTypeValue(CdsAnnotatable annotatable) {
        return CdsAnnotations.CORE_MEDIA_TYPE.isTrue(annotatable) ? APPLICATION_OCTET_STREAM : StreamUtils.getAnnotationValue(CdsAnnotations.CORE_MEDIA_TYPE, annotatable);
    }

    public static String getContentDispositionFilenameElement(CdsAnnotatable annotatable) {
        return StreamUtils.getAnnotationElement(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, annotatable);
    }

    public static String getContentDispositionFilenameValue(CdsAnnotatable annotatable) {
        return StreamUtils.getAnnotationValue(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, annotatable);
    }

    public static String getContentDispositionTypeValue(CdsAnnotatable annotatable) {
        return StreamUtils.getAnnotationValue(CdsAnnotations.CORE_CONTENT_DISPOSITION_TYPE, annotatable);
    }

    private static String getAnnotationElement(CdsAnnotations annotation, CdsAnnotatable annotatable) {
        String string;
        Object t;
        if (annotatable != null && (t = annotation.getOrDefault(annotatable)) instanceof Map) {
            Map m = (Map)t;
            string = (String)m.get("=");
        } else {
            string = null;
        }
        return string;
    }

    private static String getAnnotationValue(CdsAnnotations annotation, CdsAnnotatable annotatable) {
        String s;
        Object t;
        return annotatable != null && (t = annotation.getOrDefault(annotatable)) instanceof String ? (s = (String)t) : null;
    }
}

