/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.index;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.adapter.IndexContentProviderFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.utils.index.IndexPageServlet;
import com.sap.cds.services.utils.path.UrlPathUtil;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class IndexPageServletFactory
implements ServletAdapterFactory,
CdsRuntimeAware {
    private CdsRuntime runtime;

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Object create() {
        ArrayList<IndexContentProvider> contentProviders = new ArrayList<IndexContentProvider>();
        Iterator factoryIterator = ExtendedServiceLoader.loadAll(IndexContentProviderFactory.class, (CdsRuntime)this.runtime);
        factoryIterator.forEachRemaining(factory -> {
            if (factory.isEnabled()) {
                IndexContentProvider provider = factory.create();
                contentProviders.add(provider);
            }
        });
        Collections.sort(contentProviders, (c1, c2) -> Integer.compare(c1.order(), c2.order()));
        return new IndexPageServlet(contentProviders);
    }

    public boolean isEnabled() {
        return this.runtime.getEnvironment().getCdsProperties().getIndexPage().isEnabled();
    }

    public String getBasePath() {
        String path = this.runtime.getEnvironment().getCdsProperties().getIndexPage().getPath();
        return UrlPathUtil.normalizeBasePath(path);
    }

    public String[] getMappings() {
        return new String[]{UrlResourcePathBuilder.path(this.getBasePath()).build().getPath()};
    }

    public UrlResourcePath getServletPath() {
        return UrlResourcePathBuilder.path(this.getBasePath()).isPublic(true).build();
    }
}

