/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils.path;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsDefinitionNotFoundException;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CdsModelUtils;
import com.sap.cds.services.utils.path.CdsResourcePath;
import com.sap.cds.services.utils.path.CdsResourcePathBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class CdsServicePath {
    public static Stream<CdsResourcePath> servicePaths(CdsRuntime runtime, String protocol) {
        return CdsServicePath.calculateServicePaths(runtime, protocol).values().stream().flatMap(Collection::stream);
    }

    public static Map<String, ApplicationService> basePaths(CdsRuntime runtime, String protocol) {
        HashMap<String, ApplicationService> basePathMap = new HashMap<String, ApplicationService>();
        Map<ApplicationService, List<CdsResourcePath>> servicePaths = CdsServicePath.calculateServicePaths(runtime, protocol);
        for (Map.Entry<ApplicationService, List<CdsResourcePath>> entry : servicePaths.entrySet()) {
            for (CdsResourcePath basePath : entry.getValue()) {
                basePathMap.put(basePath.getPath(), entry.getKey());
            }
        }
        return basePathMap;
    }

    private static Map<ApplicationService, List<CdsResourcePath>> calculateServicePaths(CdsRuntime runtime, String protocol) {
        HashMap<ApplicationService, List<CdsResourcePath>> servicePathMap = new HashMap<ApplicationService, List<CdsResourcePath>>();
        runtime.getServiceCatalog().getServices(ApplicationService.class).forEach(applicationService -> {
            CdsService cdsService = null;
            try {
                cdsService = applicationService.getDefinition();
            }
            catch (CdsDefinitionNotFoundException ex) {
                return;
            }
            CdsProperties.Application.ApplicationServiceConfig config = runtime.getEnvironment().getCdsProperties().getApplication().getService(applicationService.getName());
            List<String> endpointPaths = CdsServicePath.getEndpointPaths(protocol, cdsService, config);
            if (endpointPaths.isEmpty()) {
                return;
            }
            CdsModelUtils modelUtils = new CdsModelUtils(runtime);
            boolean isPublicService = modelUtils.isPublic((CdsAnnotatable)cdsService).orElse(false);
            ArrayList serviceSubPaths = new ArrayList();
            cdsService.entities().forEach(cdsEntity -> {
                boolean isPublicEntity = modelUtils.isPublic((CdsAnnotatable)cdsEntity).orElse(isPublicService);
                ArrayList entitySubPaths = new ArrayList();
                cdsEntity.actions().forEach(cdsAction -> {
                    CdsResourcePath actionPath = CdsResourcePathBuilder.cds((CdsDefinition)cdsAction).isPublic(modelUtils.isPublic((CdsAnnotatable)cdsAction).orElse(isPublicEntity)).build();
                    entitySubPaths.add(actionPath);
                });
                cdsEntity.functions().forEach(cdsFunction -> {
                    CdsResourcePath actionPath = CdsResourcePathBuilder.cds((CdsDefinition)cdsFunction).isPublic(modelUtils.isPublic((CdsAnnotatable)cdsFunction).orElse(isPublicEntity)).build();
                    entitySubPaths.add(actionPath);
                });
                CdsResourcePath entityPath = null;
                if (isPublicEntity) {
                    entityPath = CdsResourcePathBuilder.cds((CdsDefinition)cdsEntity).subPaths(entitySubPaths.stream()).isPublic(true).build();
                } else {
                    List<String> publicEvents = modelUtils.getPublicEvents((CdsAnnotatable)cdsEntity);
                    entityPath = CdsResourcePathBuilder.cds((CdsDefinition)cdsEntity).subPaths(entitySubPaths.stream()).isPublic(false).publicEvents(publicEvents.stream()).build();
                }
                serviceSubPaths.add(entityPath);
            });
            cdsService.actions().forEach(cdsAction -> {
                CdsResourcePath actionPath = CdsResourcePathBuilder.cds((CdsDefinition)cdsAction).isPublic(modelUtils.isPublic((CdsAnnotatable)cdsAction).orElse(isPublicService)).build();
                serviceSubPaths.add(actionPath);
            });
            cdsService.functions().forEach(cdsFunction -> {
                CdsResourcePath functionPath = CdsResourcePathBuilder.cds((CdsDefinition)cdsFunction).isPublic(modelUtils.isPublic((CdsAnnotatable)cdsFunction).orElse(isPublicService)).build();
                serviceSubPaths.add(functionPath);
            });
            ArrayList<CdsResourcePath> servicePaths = new ArrayList<CdsResourcePath>();
            for (String path : endpointPaths) {
                servicePaths.add(CdsResourcePathBuilder.cds((CdsDefinition)cdsService).path(StringUtils.trim(path, '/')).subPaths(serviceSubPaths.stream()).isPublic(isPublicService).build());
            }
            servicePathMap.put((ApplicationService)applicationService, (List<CdsResourcePath>)servicePaths);
        });
        return servicePathMap;
    }

    private static List<String> getEndpointPaths(String protocol, CdsService cdsService, CdsProperties.Application.ApplicationServiceConfig config) {
        List protocolAnnotation;
        List protocolConfig;
        boolean serviceIgnoreAnnotation = CdsAnnotations.IGNORE.isTrue((CdsAnnotatable)cdsService);
        boolean serveIgnoreAnnotation = CdsAnnotations.SERVE_IGNORE.isTrue((CdsAnnotatable)cdsService);
        boolean serveIgnoreConfig = config.getServe().isIgnore();
        if (serviceIgnoreAnnotation || serveIgnoreAnnotation || serveIgnoreConfig) {
            return Collections.emptyList();
        }
        ArrayList<String> endpointPaths = new ArrayList<String>();
        config.getServe().getEndpoints().stream().filter(e -> protocol.equals(e.getProtocol())).map(e -> e.getPath()).filter(p -> !StringUtils.isEmpty(p)).forEach(endpointPaths::add);
        if (!config.getServe().getEndpoints().isEmpty()) {
            return endpointPaths;
        }
        List endpointAnnotation = CdsAnnotations.ENDPOINTS.getListOrDefault((CdsAnnotatable)cdsService);
        if (endpointAnnotation != null) {
            for (Map endpoint : endpointAnnotation) {
                String string;
                Object path;
                if (!protocol.equals(endpoint.get("protocol")) || !((path = endpoint.get("path")) instanceof String) || StringUtils.isEmpty(string = (String)path)) continue;
                endpointPaths.add(string);
            }
            if (!endpointAnnotation.isEmpty()) {
                return endpointPaths;
            }
        }
        if (!(protocolConfig = config.getServe().getProtocols()).isEmpty()) {
            if (!protocolConfig.stream().anyMatch(protocol::equals)) {
                return Collections.emptyList();
            }
        }
        if (protocolConfig.isEmpty() && (protocolAnnotation = CdsAnnotations.PROTOCOLS.getListOrDefault((CdsAnnotatable)cdsService)) != null && !protocolAnnotation.isEmpty()) {
            if (!protocolAnnotation.stream().anyMatch(protocol::equals)) {
                return Collections.emptyList();
            }
        }
        if (!StringUtils.isEmpty(config.getServe().getPath())) {
            endpointPaths.add(config.getServe().getPath());
        }
        if (!endpointPaths.isEmpty()) {
            return endpointPaths;
        }
        List pathAnnotation = CdsAnnotations.PATH.getListOrDefault((CdsAnnotatable)cdsService);
        if (pathAnnotation != null) {
            pathAnnotation.stream().filter(p -> !StringUtils.isEmpty(p)).forEach(endpointPaths::add);
        }
        if (!endpointPaths.isEmpty()) {
            return endpointPaths;
        }
        return Arrays.asList(config.getName());
    }
}

