/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnNullValue;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.services.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class ODataUtils {
    public static String toODataName(String cdsEntityName) {
        return cdsEntityName.replace(".", "_");
    }

    public static String toODataTarget(String bindingParameter, String parameter, CqnReference ref, final boolean v2, boolean applyParameterPrefix) {
        List segments;
        List list = segments = ref == null ? Collections.emptyList() : ref.segments();
        if (segments.isEmpty()) {
            return parameter;
        }
        String prefix = "cqn".equals(parameter) ? bindingParameter : parameter;
        final StringBuilder target = new StringBuilder((String)(StringUtils.isEmpty(prefix) ? "" : (applyParameterPrefix ? "$Parameter/" + prefix : prefix)));
        if (!segments.isEmpty() && target.length() > 0 && target.charAt(target.length() - 1) != '/') {
            target.append("/");
        }
        for (CqnReference.Segment segment : segments) {
            target.append(segment.id());
            if (segment.filter().isPresent()) {
                target.append("(");
                final AtomicInteger beforeIsActiveEntityPosition = new AtomicInteger(-1);
                ((CqnPredicate)segment.filter().get()).accept(new CqnVisitor(){

                    public void visit(CqnComparisonPredicate predicate) {
                        if (predicate.operator() == CqnComparisonPredicate.Operator.EQ || predicate.operator() == CqnComparisonPredicate.Operator.IS) {
                            CqnValue left = predicate.left();
                            CqnValue right = predicate.right();
                            CqnValue value = null;
                            String key = null;
                            if (left instanceof CqnElementRef) {
                                CqnElementRef ref = (CqnElementRef)left;
                                key = ref.firstSegment();
                                value = right;
                            } else if (right instanceof CqnElementRef) {
                                CqnElementRef ref = (CqnElementRef)right;
                                key = ref.firstSegment();
                                value = left;
                            }
                            if (key != null) {
                                Object theValue = null;
                                if (value instanceof CqnLiteral) {
                                    CqnLiteral literal = (CqnLiteral)value;
                                    theValue = literal.value();
                                    if (theValue instanceof String) {
                                        String string = (String)theValue;
                                        if (!ODataUtils.isUUID(string)) {
                                            theValue = "'" + String.valueOf(theValue) + "'";
                                        } else if (v2) {
                                            theValue = "guid'" + String.valueOf(theValue) + "'";
                                        }
                                    }
                                } else if (value instanceof CqnNullValue) {
                                    theValue = "null";
                                } else if (value instanceof CqnPlain) {
                                    CqnPlain plain = (CqnPlain)value;
                                    theValue = plain.plain();
                                }
                                if (theValue != null) {
                                    String toAppend = key + "=" + String.valueOf(theValue) + ",";
                                    int insertAt = beforeIsActiveEntityPosition.get();
                                    if (insertAt > -1) {
                                        target.insert(insertAt, toAppend);
                                        beforeIsActiveEntityPosition.set(insertAt + toAppend.length());
                                    } else {
                                        if (key.equals("IsActiveEntity")) {
                                            beforeIsActiveEntityPosition.set(target.length());
                                        }
                                        target.append(toAppend);
                                    }
                                }
                            }
                        }
                    }
                });
                target.deleteCharAt(target.length() - 1);
                target.append(")");
            }
            target.append("/");
        }
        if (!segments.isEmpty()) {
            target.deleteCharAt(target.length() - 1);
        }
        return target.toString();
    }

    private static boolean isUUID(String s) {
        try {
            UUID.fromString(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

