/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

public class TenantAwareCache<T, V> {
    private final Supplier<String> tenantSupplier;
    private final Supplier<T> valueSupplier;
    private final Supplier<V> validatorSupplier;
    private final Cache<String, CacheEntry<T, V>> cached;

    public static <T> TenantAwareCache<T, CdsModel> create(Supplier<T> valueSupplier, CdsRuntime runtime) {
        Supplier<String> tenantSupplier = () -> RequestContext.isActive() ? RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo().getTenant() : runtime.getProvidedUserInfo().getTenant();
        CdsProperties.Model.Provider.Cache cacheConfig = runtime.getEnvironment().getCdsProperties().getModel().getProvider().getCache();
        return new TenantAwareCache<T, CdsModel>(cacheConfig, tenantSupplier, valueSupplier, () -> RequestContext.getCurrent((CdsRuntime)runtime).getModel());
    }

    public static <T, V> TenantAwareCache<T, V> create(Supplier<String> tenantSupplier, Supplier<T> valueSupplier, Supplier<V> validatorSupplier) {
        return new TenantAwareCache<T, V>(null, tenantSupplier, valueSupplier, validatorSupplier);
    }

    private TenantAwareCache(CdsProperties.Model.Provider.Cache cacheConfig, Supplier<String> tenantSupplier, Supplier<T> valueSupplier, Supplier<V> validatorSupplier) {
        this.tenantSupplier = tenantSupplier;
        this.valueSupplier = valueSupplier;
        this.validatorSupplier = validatorSupplier;
        Caffeine cache = Caffeine.newBuilder();
        if (cacheConfig != null) {
            if (cacheConfig.getMaxSize() >= 0) {
                cache.maximumSize((long)cacheConfig.getMaxSize());
            }
            if (cacheConfig.getExpirationTime() >= 0) {
                cache.expireAfterAccess(Duration.ofSeconds(cacheConfig.getExpirationTime()));
            }
        }
        this.cached = cache.build();
    }

    public T findOrCreate() {
        String tenantName = this.tenantSupplier.get();
        String tenantKey = tenantName == null ? "" : tenantName.trim();
        V validator = this.validatorSupplier.get();
        CacheEntry entry = (CacheEntry)this.cached.getIfPresent((Object)tenantKey);
        if (entry != null && !Objects.equals(validator, entry.validator.get())) {
            this.cached.invalidate((Object)tenantKey);
            entry = null;
        }
        if (entry == null) {
            entry = (CacheEntry)this.cached.get((Object)tenantKey, key -> new CacheEntry<T, Object>(this.valueSupplier.get(), validator));
        }
        return entry.value;
    }

    private static class CacheEntry<T, V> {
        private final T value;
        private final WeakReference<V> validator;

        public CacheEntry(T value, V validator) {
            this.value = value;
            this.validator = new WeakReference<V>(validator);
        }
    }
}

