/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.utils;

import com.sap.cds.services.utils.StringUtils;
import org.slf4j.MDC;

public class TenantIdUtils {
    public static final String TENANT_ID_FIELD = "tenant_id";
    public static final String TENANT_ID_UNKNOWN = "-";

    private TenantIdUtils() {
    }

    public static boolean mdcHasEntry() {
        return !TenantIdUtils.isUnknown(TenantIdUtils.getFromMDC());
    }

    public static void putInMDC(String tenantId) {
        if (!TenantIdUtils.isUnknown(tenantId)) {
            MDC.put((String)TENANT_ID_FIELD, (String)tenantId);
        }
    }

    public static String getFromMDC() {
        return MDC.get((String)TENANT_ID_FIELD);
    }

    public static void clearMDC() {
        MDC.remove((String)TENANT_ID_FIELD);
    }

    private static boolean isUnknown(String tenantId) {
        return StringUtils.isEmpty(tenantId) || TENANT_ID_UNKNOWN.equals(tenantId);
    }
}

