/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

import java.util.Iterator;
import java.util.ServiceLoader;

/**
 * Internal ServiceLoader class.
 */
public final class Cds4jServiceLoader {

	private Cds4jServiceLoader() {
	}

	public static <T> T load(Class<T> clazz) {
		Iterator<T> iterator = ServiceLoader.load(clazz).iterator();
		if (iterator.hasNext()) {
			return iterator.next();
		}
		throw new CdsException("Cannot find implementation for " + clazz.getCanonicalName());
	}

}
