/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

import com.sap.cds.reflect.CdsModel;

public interface CdsDataStoreConnector {

	/**
	 * Returns the {@link CdsDataStore}.
	 * 
	 * @return the {@code CdsDataStore}
	 */
	CdsDataStore connect();

	/**
	 * Returns the {@link CdsDataStore}.
	 * 
	 * @param session the session context object
	 * @return the {@code CdsDataStore}
	 */
	CdsDataStore connect(SessionContext session);

	/**
	 * Returns the {@link CdsModel}.
	 * 
	 * @return the {@code CdsModel}
	 */
	CdsModel reflect();

	default Capabilities capabilities() {
		return Capabilities.ALL;
	}

	public interface Capabilities {

		public static final Capabilities ALL = new Capabilities() {
			public boolean supportsViewsWithParameters() {
				return true;
			}
		};

		default boolean supportsInsert() {
			return true;
		}

		default boolean supportsUpsert() {
			return true;
		}

		default boolean supportsUpdate() {
			return true;
		}

		default boolean supportsDelete() {
			return true;
		}

		default boolean supportsParameters() {
			return true;
		}

		default boolean supportsViewsWithParameters() {
			return false;
		}

		default boolean supportsLock() {
			return true;
		}

	}

}
