/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

/**
 * Represents a single result data set of the {@link CdsDataStore}. It can be
 * accessed as a {@code Map} or, via the {@code as} method, in a typed way by an
 * accessor interface. Moreover, it can be serialized to JSON.
 */
public interface Row extends CdsData {

	/**
	 * Returns this {@code Row} mapped to the given {@code type}.
	 * 
	 * @param      <T> the return type
	 * @param type the type this {@code Row} is mapped to
	 * @return this {@code Row} mapped to type {@code T}
	 */
	<T> T as(Class<T> type);

}
