/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

import java.time.Instant;
import java.util.Locale;

public final class SessionContext {

	private final UserContext userContext;
	private final Instant now;
	private final Instant validTo;
	private final Instant validFrom;

	private SessionContext(Builder builder) {
		this.userContext = builder.userContext;
		this.now = builder.now;
		this.validTo = builder.validTo;
		this.validFrom = builder.validFrom;
	}

	public static Builder create() {
		return new Builder();
	}

	public static class Builder {
		private UserContext userContext;
		private Instant now;
		private Instant validTo;
		private Instant validFrom;

		public Builder() {
			this(UserContext.create().build(), null, null, null);
		}

		public Builder(UserContext userContext, Instant now, Instant validTo, Instant validFrom) {
			this.userContext = userContext;
			this.now = now;
			this.validTo = validTo;
			this.validFrom = validFrom;
		}

		public Builder setUserContext(UserContext userContext) {
			this.userContext = userContext;
			return this;
		}

		public Builder setNow(Instant now) {
			this.now = now;
			return this;
		}

		public Builder setValidTo(Instant validTo) {
			this.validTo = validTo;
			return this;
		}

		public Builder setValidFrom(Instant validFrom) {
			this.validFrom = validFrom;
			return this;
		}

		public SessionContext build() {
			return new SessionContext(this);
		}
	}

	public UserContext getUserContext() {
		return userContext;
	}

	public Instant getNow() {
		return now != null ? now : Instant.now();
	}

	public Instant getValidTo() {
		return validTo;
	}

	public Instant getValidFrom() {
		return validFrom;
	}

	public Locale getLocale() {
		return userContext.getLocale();
	}
}
