/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

import java.util.Locale;

public final class UserContext {

	private final String id;
	private final Locale locale;

	private UserContext(Builder builder) {
		this.id = builder.id;
		this.locale = builder.locale;
	}

	public static Builder create() {
		return new Builder();
	}

	public static class Builder {
		private String id;
		private Locale locale;

		public Builder() {
			this(null, null);
		}

		public Builder(String id, Locale locale) {
			this.id = id;
			this.locale = locale;
		}

		public Builder setId(String id) {
			this.id = id;
			return this;
		}

		public Builder setLocale(Locale locale) {
			this.locale = locale;
			return this;
		}

		public UserContext build() {
			return new UserContext(this);
		}

	}

	public String getId() {
		return id;
	}

	public Locale getLocale() {
		return locale;
	}
}
