/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.mtx;

import com.sap.cds.reflect.CdsModel;

/**
 * Provides access to tenant-specific CDS and EDMX models
 * @param <M> EDMX model type
 */


public interface MetaDataAccessor<M> {
    /**
     *
     * @param tenantId tenant identifier
     * @param serviceName service name, can be empty or null
     * @param language language, can be empty or null
     * @return EDMX model
     */
    public M getEdmx(String tenantId, String serviceName, String language);

    /**
     *
      * @param tenantId tenant identifier
     * @return CDS model
     */
    public CdsModel getCdsModel(String tenantId);

    /**
     * Rereads CDS and EDMX models for the specified tenant if they have changed
     * @param tenantId tenant identifier
     */
    public void refresh(String tenantId);

    /**
     * evicts CDS and EDMX models for the specified tenant
     * @param tenantId tenant identifier
     */
    public void evict(String tenantId);
}
