/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;

import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate.Operator;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference.Segment;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsEntity;

/**
 * Service Provider Interface
 */
public interface CqnBuilder {

	static CqnBuilder instance() {
		return CDS.QL.builder;
	}

	/**
	 * @deprecated instead use {@link CQL#param}
	 * @param <T> the type of the parameter
	 * @return the parameter
	 */
	@Deprecated
	static <T> Parameter<T> param() {
		return CQL.param();
	}

	/**
	 * @deprecated instead use {@link CQL#param}
	 * @param <T>  the type of the parameter
	 * @param name the name of the parameter
	 * @return the parameter
	 */
	@Deprecated
	static <T> Parameter<T> param(String name) {
		return CQL.param(name);
	}

	/**
	 * @deprecated instead use {@link CQL#literal}
	 * @param <T> the type of the literal
	 * @param val the literal value
	 * @return the literal
	 */
	@Deprecated
	static <T> Literal<T> literal(T val) {
		return CQL.literal(val);
	}

	/**
	 * @deprecated instead use {@link CQL#plain}
	 * @param val the plain value
	 * @return the plain value
	 */
	@Deprecated
	static CqnValue plain(String val) {
		return CQL.plain(val);
	}

	/**
	 * @deprecated instead use {@link CQL#toUpper}
	 * @param val the String value to be converted
	 * @return the CDS QL expression for upper case conversion
	 */
	@Deprecated
	static Value<String> toUpper(String val) {
		return CQL.toUpper(val);
	}

	/**
	 * @deprecated instead use {@link CQL#toLower}
	 * @param val the String value to be converted
	 * @return the CDS QL expression for lower case conversion
	 */
	@Deprecated
	static Value<String> toLower(String val) {
		return CQL.toLower(val);
	}

	/**
	 * @deprecated instead use {@link CQL#func}
	 * @param <T>  the return type of the function call
	 * @param name the name of the function to be called
	 * @param args the arguments of the function
	 * @return the CDS QL function call
	 */
	@Deprecated
	static <T> FunctionCall<T> func(String name, CqnValue... args) {
		return CQL.func(name, args);
	}

	/**
	 * @deprecated instead use {@link CQL#not}
	 * @param p the {@code CqnPredicate} to be negated
	 * @return the negated predicate
	 */
	@Deprecated
	static Predicate not(CqnPredicate p) {
		return CDS.QL.create.not(p);
	}

	Select<StructuredType<?>> select(String entityName);

	Select<StructuredType<?>> select(String entityName, UnaryOperator<StructuredType<?>> path);

	Select<StructuredType<?>> select(CqnSelect select);

	Insert insert(String entityName, UnaryOperator<StructuredType<?>> path);

	Upsert upsert(String entityName, UnaryOperator<StructuredType<?>> path);

	Update<StructuredType<?>> update(String entityName, UnaryOperator<StructuredType<?>> path);

	Delete<StructuredType<?>> delete(String entityName, UnaryOperator<StructuredType<?>> path);

	Select<StructuredType<?>> select(CqnStructuredTypeRef ref);

	Insert insert(CqnStructuredTypeRef ref);

	Upsert upsert(CqnStructuredTypeRef ref);

	Update<StructuredType<?>> update(CqnStructuredTypeRef ref);

	Delete<StructuredType<?>> delete(CqnStructuredTypeRef ref);

	Select<StructuredType<?>> select(CdsEntity entity);

	Select<StructuredType<?>> select(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Insert insert(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Upsert upsert(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Update<StructuredType<?>> update(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	Delete<StructuredType<?>> delete(CdsEntity entity, UnaryOperator<StructuredType<?>> path);

	<E extends StructuredType<E>> Select<E> select(Class<E> entity);

	<E extends StructuredType<E>, R extends StructuredType<R>> Select<R> select(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>> Select<E> select(Source<E> source);

	<E extends StructuredType<?>> Insert insert(E entity);

	<E extends StructuredType<?>> Upsert upsert(E entity);

	<E extends StructuredType<?>> Update<E> update(E entity);

	<E extends StructuredType<?>> Delete<E> delete(E entity);

	<E extends StructuredType<E>, R extends StructuredType<R>> Insert insert(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>, R extends StructuredType<R>> Delete<R> delete(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>, R extends StructuredType<R>> Upsert upsert(Class<E> entity, Function<E, R> path);

	<E extends StructuredType<E>, R extends StructuredType<R>> Update<R> update(Class<E> entity, Function<E, R> path);

	Predicate copy(CqnPredicate pred);

	Predicate copy(CqnPredicate pred, CqnModifier modifier);

	<S extends CqnStatement, R extends S> R copy(S statement);

	<S extends CqnStatement, R extends S> R copy(S statement, CqnModifier modifier);

	CqnParser parse();

	QueryBuilderSupport support();

	public interface QueryBuilderSupport {

		<T> Parameter<T> param();

		Value<String> toLower(Value<String> val);

		Value<String> toUpper(Value<String> val);

		<T> Parameter<T> param(String name);

		<T> Literal<T> literal(T val);

		Value<?> plain(String val);

		<T> FunctionCall<T> func(String functionName, Iterable<? extends CqnValue> args);

		BooleanFunction booleanFunc(String functionName, List<? extends CqnValue> args);

		Predicate not(CqnPredicate p);

		Predicate connect(Operator operator, Iterable<? extends CqnPredicate> predicates);

		StructuredType<?> entity(String qualifiedName);

		StructuredType<?> to(String path);

		StructuredType<?> to(List<? extends Segment> segments);

		<T> ElementRef<T> get(String path);

		<T> ElementRef<T> get(List<? extends Segment> segments);

		RefSegment refSegment(String id);

		List<RefSegment> refSegments(List<String> segmentIds);

		Predicate comparison(CqnValue lhs, CqnComparisonPredicate.Operator op, CqnValue rhs);

		Predicate in(CqnValue lhs, Collection<? extends CqnValue> values);

		Predicate search(String term);

		Predicate exists(CqnSelect subQuery);

		ElementRef<Instant> now();

		ElementRef<Instant> validFrom();

		ElementRef<Instant> validTo();

		ElementRef<String> userLocale();

		ElementRef<String> userId();

	}

}
