/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import java.util.List;

import com.sap.cds.ql.cqn.CqnElementRef;

public interface ElementRef<T> extends Value<T>, CqnElementRef {

	List<RefSegment> segments();

	@Override
	default RefSegment rootSegment() {
		return segments().get(0);
	}

	@Override
	default RefSegment targetSegment() {
		return segments().get(segments().size() - 1);
	}

}
