/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import static java.util.Arrays.asList;

import java.util.List;
import java.util.function.Function;

import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnVisitor;

public interface Expand<T extends StructuredType<?>> extends CqnExpand, CqnSelectListItem {

	/**
	 * Sets the limit of the expand.
	 * 
	 * @param limit the maximum number of entries returned by the expand
	 * @return this expand
	 */
	default Expand<T> limit(long limit) {
		return limit(limit, 0);
	}

	/**
	 * Sets the limit and offset of the expand.
	 * 
	 * @param limit  the maximum number of entries returned by the expand
	 * @param offset the number of entries that shall be skipped
	 * @return this expand
	 */
	Expand<T> limit(long limit, long offset);

	Expand<T> orderBy(String... refs);

	Expand<T> orderBy(List<CqnSortSpecification> sortSpec);

	Expand<T> orderBy(Function<T, CqnSortSpecification> sort);

	Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2);

	Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2,
			Function<T, CqnSortSpecification> sort3);

	Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2,
			Function<T, CqnSortSpecification> sort3, Function<T, CqnSortSpecification> sort4);

	Expand<T> orderBy(Function<T, CqnSortSpecification> sort1, Function<T, CqnSortSpecification> sort2,
			Function<T, CqnSortSpecification> sort3, Function<T, CqnSortSpecification> sort4,
			Function<T, CqnSortSpecification> sort5);

	@SuppressWarnings("unchecked")
	Expand<T> orderBy(Function<T, CqnSortSpecification>... sortSpec);

	default Expand<T> orderBy(CqnSortSpecification... sortSpec) {
		return orderBy(asList(sortSpec));
	}

	@Override
	default void accept(CqnVisitor visitor) {
		CqnExpand.super.accept(visitor);
	}

}
