/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelectListItem;

public interface StructuredType<T extends StructuredType<T>> extends Source<T> {

	StructuredType<?> to(String path);

	<E extends StructuredType<E>> E to(String path, Class<E> type);

	<E> ElementRef<E> get(String path);

	<E> ElementRef<E> get(String path, Class<E> type);

	T filter(CqnPredicate p);

	T filter(Function<T, CqnPredicate> p);

	T matching(Map<String, ?> values);

	CqnSelectListItem inline();

	default CqnSelectListItem inline(Function<T, CqnSelectListItem> item) {
		return inline(Collections.singletonList(item));
	}

	default CqnSelectListItem inline(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2) {
		return inline(Arrays.asList(item1, item2));
	}

	default CqnSelectListItem inline(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3) {
		return inline(Arrays.asList(item1, item2, item3));
	}

	default CqnSelectListItem inline(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4) {
		return inline(Arrays.asList(item1, item2, item3, item4));
	}

	default CqnSelectListItem inline(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4,
			Function<T, CqnSelectListItem> item5) {
		return inline(Arrays.asList(item1, item2, item3, item4, item5));
	}

	default CqnSelectListItem inline(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4,
			Function<T, CqnSelectListItem> item5, Function<T, CqnSelectListItem> item6) {
		return inline(Arrays.asList(item1, item2, item3, item4, item5, item6));
	}

	default CqnSelectListItem inline(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4,
			Function<T, CqnSelectListItem> item5, Function<T, CqnSelectListItem> item6,
			Function<T, CqnSelectListItem> item7) {
		return inline(Arrays.asList(item1, item2, item3, item4, item5, item6, item7));
	}

	@SuppressWarnings("unchecked")
	default CqnSelectListItem inline(Function<T, CqnSelectListItem>... items) {
		return inline(Arrays.asList(items));
	}

	CqnSelectListItem inline(List<Function<T, CqnSelectListItem>> items);
	
	CqnSelectListItem inline(Iterable<CqnSelectListItem> items);

	CqnSelectListItem inline(CqnSelectListItem... items);

	CqnSelectListItem inline(String... refs);

	Expand<T> expand();

	default Expand<T> expand(Function<T, CqnSelectListItem> item) {
		return expand(Collections.singletonList(item));
	}

	default Expand<T> expand(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2) {
		return expand(Arrays.asList(item1, item2));
	}

	default Expand<T> expand(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3) {
		return expand(Arrays.asList(item1, item2, item3));
	}

	default Expand<T> expand(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4) {
		return expand(Arrays.asList(item1, item2, item3, item4));
	}

	default Expand<T> expand(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4,
			Function<T, CqnSelectListItem> item5) {
		return expand(Arrays.asList(item1, item2, item3, item4, item5));
	}

	default Expand<T> expand(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4,
			Function<T, CqnSelectListItem> item5, Function<T, CqnSelectListItem> item6) {
		return expand(Arrays.asList(item1, item2, item3, item4, item5, item6));
	}

	default Expand<T> expand(Function<T, CqnSelectListItem> item1, Function<T, CqnSelectListItem> item2,
			Function<T, CqnSelectListItem> item3, Function<T, CqnSelectListItem> item4,
			Function<T, CqnSelectListItem> item5, Function<T, CqnSelectListItem> item6,
			Function<T, CqnSelectListItem> item7) {
		return expand(Arrays.asList(item1, item2, item3, item4, item5, item6, item7));
	}

	@SuppressWarnings("unchecked")
	default Expand<T> expand(Function<T, CqnSelectListItem>... items) {
		return expand(Arrays.asList(items));
	}

	Expand<T> expand(List<Function<T, CqnSelectListItem>> items);

	Expand<T> expand(Iterable<CqnSelectListItem> items);

	Expand<T> expand(CqnSelectListItem... items);

	Expand<T> expand(String... refs);

	CqnSelectListItem _all();

	Predicate exists(Function<T, Select<?>> subQuery);

	@Override
	StructuredTypeRef asRef();

}
