/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import java.util.List;

import com.sap.cds.ql.cqn.CqnStructuredTypeRef;

public interface StructuredTypeRef extends CqnStructuredTypeRef {

	List<RefSegment> segments();

	StructuredTypeRef as(String alias);

	@Override
	default RefSegment rootSegment() {
		return segments().get(0);
	}

	@Override
	default RefSegment targetSegment() {
		return segments().get(segments().size() - 1);
	}

}
