/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Iterator;
import java.util.Map;

import com.sap.cds.reflect.CdsEntity;

/**
 * Contains the analysis result for a {@link CqnStructuredTypeRef} or
 * {@link CqnStatement}.
 */
public interface AnalysisResult extends Iterable<ResolvedSegment> {

	/**
	 * Returns an iterator over {@link ResolvedSegment ResolvedSegment(s)}.
	 *
	 * @return an Iterator
	 */
	Iterator<ResolvedSegment> iterator();

	/**
	 * Returns a reverse order iterator over {@link ResolvedSegment
	 * ResolvedSegment(s)}, starting from the target segment.
	 *
	 * @return an Iterator
	 */
	Iterator<ResolvedSegment> reverse();

	/**
	 * Returns the {@link CdsEntity} that is the root of the {@code ref}.
	 *
	 * @return the root {@code CdsEntity}
	 */
	CdsEntity rootEntity();

	/**
	 * Returns the element name to value mapping for the key elements of the
	 * {@link CdsEntity} that is the root of the {@code ref}.
	 * 
	 * Extracts the key values, i.e. the values of the key elements of the entity
	 * that is the root of the {@code ref}. If the filter does not uniquely restrict
	 * a key element to a particular value, the element's name is mapped to
	 * {@code null}.
	 *
	 * @return a map relating key element names to key values
	 */
	Map<String, Object> rootKeys();

	/**
	 * Returns the element name to value mapping for the key elements of the
	 * {@link CdsEntity} that is targeted by the {@code ref}.
	 * 
	 * Extracts the key values, i.e. the values of the key elements to the entity
	 * targeted by the {@code ref} and optionally the statement's {@code where}
	 * condition. If the combined filter does not uniquely restrict a key element to
	 * a particular value, the element's name is mapped to {@code null}.
	 *
	 * @return a map relating key element names to key values
	 */
	Map<String, Object> targetKeys();

	/**
	 * Returns the {@link CdsEntity} targeted by the {@code ref}.
	 *
	 * @return the target {@code CdsEntity}
	 */
	CdsEntity targetEntity();

}
