/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;

public interface CqnConnectivePredicate extends CqnPredicate {

	List<CqnPredicate> predicates();

	Operator operator();

	@Override
	default void accept(CqnVisitor visitor) {
		predicates().forEach(p -> p.accept(visitor));

		visitor.visit(this);
	}

	enum Operator {
		AND("and"), OR("or");

		public final String symbol;

		private Operator(String op) {
			this.symbol = op;
		}
	}

}
