/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Optional;

public interface CqnDelete extends CqnStatement {

	Optional<CqnPredicate> where();

	@Override
	default boolean isDelete() {
		return true;
	}

	@Override
	default CqnDelete asDelete() {
		return this;
	}

	default void accept(CqnVisitor visitor) {
		ref().accept(visitor);
		where().ifPresent(w -> w.accept(visitor));

		visitor.visit(this);
	}

}
