/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

public interface CqnElementRef extends CqnReference, CqnValue, CqnSelectListValue {

	public static final String $KEY = "$key";

	@Override
	default boolean isRef() {
		return true;
	}

	@Override
	default CqnElementRef asRef() {
		return this;
	}

	@Override
	default boolean isValue() {
		return true;
	}

	@Override
	default CqnValue value() {
		return this;
	}

	@Override
	default void accept(CqnVisitor visitor) {
		visitor.visit(this);
	}

}
