/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Optional;

/**
 * The entity selector describes a basic selection from an entity set.
 */
public interface CqnEntitySelector {

	/**
	 * Returns the ref to the entity set of this selector
	 * 
	 * @return the reference
	 */
	CqnStructuredTypeRef ref();

	/**
	 * Returns the selected items
	 * 
	 * @return the select list items
	 */
	List<CqnSelectListItem> items();

	/**
	 * Returns the order of the selection result
	 * 
	 * @return the result order
	 */
	List<CqnSortSpecification> orderBy();

	/**
	 * Returns the limit and offset of this selector
	 * 
	 * @return the limit and offset
	 */
	Optional<CqnLimit> limit();

}
