/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Optional;

public interface CqnExpand extends CqnSelectList, CqnEntitySelector {

	String displayName();

	default Optional<String> alias() {
		return Optional.empty();
	}

	@Override
	default boolean isExpand() {
		return true;
	}

	@Override
	default CqnExpand asExpand() {
		return this;
	}

	@Override
	default void accept(CqnVisitor visitor) {
		visitor.visit(this);
	}

}
