/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.stream.Collectors;

public interface CqnExpression extends CqnValue {

	@Override
	default boolean isExpression() {
		return true;
	}

	@Override
	default CqnExpression asExpression() {
		return this;
	}

	@Override
	default String toJson() {
		return "[" + tokens().map(CqnToken::toJson).collect(Collectors.joining(", ")) + "]";
	}

	@Override
	default void accept(CqnVisitor visitor) {
		tokens().forEach(t -> t.accept(visitor));

		visitor.visit(this);
	}

}
