/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;

public interface CqnFunc extends CqnValue {

	/**
	 * Returns the name of the function to be called.
	 *
	 * @return the function name
	 */
	String func();

	/**
	 * Returns the arguments of this function call.
	 *
	 * @return the list of arguments
	 */
	List<CqnValue> args();

	@Override
	default boolean isFunction() {
		return true;
	}

	@Override
	default CqnFunc asFunction() {
		return this;
	}

	default void accept(CqnVisitor visitor) {
		// TODO - iterate over arguments ?
		visitor.visit(this);
	}
}
