/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Collection;

public interface CqnInPredicate extends CqnPredicate {

	CqnValue value();

	Collection<CqnValue> values();

	@Override
	default void accept(CqnVisitor visitor) {
		value().accept(visitor);
		values().forEach(v -> v.accept(visitor));

		visitor.visit(this);
	}

}
