/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

import com.sap.cds.JSONizable;

public interface CqnLimit extends JSONizable {

	/**
	 * @deprecated instead use {@link #top}
	 * 
	 * @return the maximum number of rows to be returned
	 */
	@Deprecated
	CqnValue limit();

	/**
	 * Returns {@link #limit} as long.
	 * 
	 * @throws ClassCastException if limit is not a numeric literal
	 * @return the maximum number of rows to be returned
	 */
	long top();

	/**
	 * @deprecated instead use {@link #skip}
	 * 
	 * @return the number of rows to be skipped
	 */
	@Deprecated
	Optional<CqnValue> offset();

	/**
	 * Returns {@link #offset} as long.
	 * 
	 * @throws ClassCastException if offset is not a numeric literal
	 * @return the number of rows to be skipped
	 */
	long skip();

	default void accept(CqnVisitor visitor) {
		limit().accept(visitor);
		offset().ifPresent(o -> o.accept(visitor));

		visitor.visit(this);
	}

	default Stream<CqnParameter> params() {
		List<CqnParameter> params = new ArrayList<>();

		CqnVisitor v = new CqnVisitor() {
			@Override
			public void visit(CqnParameter p) {
				params.add(p);
			}
		};

		limit().accept(v);
		offset().ifPresent(o -> o.accept(v));

		return params.stream();
	}

}
