/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Optional;

import com.sap.cds.JSONizable;

public interface CqnReference extends CqnToken {

	List<? extends Segment> segments();

	default Segment rootSegment() {
		return segments().get(0);
	}

	default Segment targetSegment() {
		return segments().get(segments().size() - 1);
	}

	default String firstSegment() {
		return rootSegment().id();
	}

	default String lastSegment() {
		return targetSegment().id();
	}

	interface Segment extends JSONizable {

		Optional<CqnPredicate> filter();

		String id();

		default void accept(CqnVisitor visitor) {
			visitor.visit(this);
		}
	}

}
