/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Optional;

public interface CqnSelect extends CqnStatement, CqnEntitySelector, CqnToken, CqnSource {

	CqnSource from();

	boolean isDistinct();

	boolean hasInlineCount();

	/**
	 * @deprecated instead use {@link CqnEntitySelector#items}
	 * @return the select list items
	 */
	@Deprecated
	default List<CqnSelectListItem> columns() {
		return items();
	}

	List<CqnSelectListItem> groupBy();

	List<String> excluding();

	Optional<CqnPredicate> where();

	Optional<CqnPredicate> having();

	Optional<CqnLock> getLock();

	Optional<CqnPredicate> search();

	@Override
	default boolean isSelect() {
		return true;
	}

	@Override
	default CqnSelect asSelect() {
		return this;
	}

	default void accept(CqnVisitor visitor) {
		from().accept(visitor);
		items().forEach(c -> c.accept(visitor));
		where().ifPresent(w -> w.accept(visitor));
		search().ifPresent(s -> s.accept(visitor));
		groupBy().forEach(c -> c.accept(visitor));
		having().ifPresent(h -> h.accept(visitor));
		orderBy().forEach(o -> o.accept(visitor));
		limit().ifPresent(l -> l.accept(visitor));

		visitor.visit(this);
	}

}
